/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import org.apache.log4j.Appender;
import org.apache.log4j.JBossAppenderHandler;
import org.apache.log4j.spi.AppenderAttachable;
import org.jboss.logmanager.Logger;

class Appenders {
    private static final Logger.AttachmentKey<CopyOnWriteArrayList<Appender>> APPENDERS_KEY = new Logger.AttachmentKey();

    Appenders() {
    }

    public static void attachAppender(final Logger logger, Appender appender) {
        Handler[] newHandlers;
        Handler[] oldHandlers;
        block0: do {
            for (Handler handler : oldHandlers = logger.getHandlers()) {
                if (handler instanceof JBossAppenderHandler) break block0;
            }
            int size = oldHandlers.length;
            newHandlers = Arrays.copyOf(oldHandlers, size + 1);
            newHandlers[size] = System.getSecurityManager() == null ? new JBossAppenderHandler(logger) : AccessController.doPrivileged(new PrivilegedAction<Handler>(){

                @Override
                public Handler run() {
                    return new JBossAppenderHandler(logger);
                }
            });
        } while (!logger.compareAndSetHandlers(oldHandlers, newHandlers));
        Appenders.getAppenderList(logger).addIfAbsent(appender);
    }

    public static List<Appender> getAppenders(Logger logger) {
        CopyOnWriteArrayList<Appender> appenders = Appenders.getAppenderList(logger);
        if (appenders == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Appender>(appenders);
    }

    public static Appender getAppender(Logger logger, String name) {
        Appender result = null;
        if (name != null) {
            List<Appender> appenders = Appenders.getAppenders(logger);
            for (Appender appender : appenders) {
                if (!name.equals(appender.getName())) continue;
                result = appender;
                break;
            }
        }
        return result;
    }

    public static boolean isAppenderAttached(Logger logger, Appender appender) {
        return Appenders.getAppenders(logger).contains(appender);
    }

    public static List<Appender> removeAllAppenders(Logger logger) {
        List<Appender> result = Collections.emptyList();
        CopyOnWriteArrayList<Appender> currentAppenders = Appenders.getAppenderList(logger);
        if (currentAppenders != null && !currentAppenders.isEmpty()) {
            result = new ArrayList<Appender>(currentAppenders);
            currentAppenders.clear();
        }
        return result;
    }

    public static boolean removeAppender(Logger logger, Appender appender) {
        boolean result = false;
        CopyOnWriteArrayList<Appender> currentAppenders = Appenders.getAppenderList(logger);
        if (currentAppenders != null) {
            result = currentAppenders.remove(appender);
        }
        return result;
    }

    public static void closeAppenders(Logger logger) {
        CopyOnWriteArrayList<Appender> appenders = Appenders.getAppenderList(logger);
        for (Appender appender : appenders) {
            if (!(appender instanceof AppenderAttachable)) continue;
            appender.close();
        }
    }

    static CopyOnWriteArrayList<Appender> getAppenderList(final Logger logger) {
        CopyOnWriteArrayList<Object> result = (CopyOnWriteArrayList)logger.getAttachment(APPENDERS_KEY);
        if (result == null) {
            CopyOnWriteArrayList<Appender> current;
            result = new CopyOnWriteArrayList();
            if (System.getSecurityManager() == null) {
                current = (CopyOnWriteArrayList<Appender>)logger.attachIfAbsent(APPENDERS_KEY, result);
            } else {
                final CopyOnWriteArrayList attachment = result;
                current = AccessController.doPrivileged(new PrivilegedAction<CopyOnWriteArrayList<Appender>>(){

                    @Override
                    public CopyOnWriteArrayList<Appender> run() {
                        return (CopyOnWriteArrayList)logger.attachIfAbsent(APPENDERS_KEY, (Object)attachment);
                    }
                });
            }
            if (current != null) {
                result = current;
            }
        }
        return result;
    }
}

