/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.cli.embedded.Contexts;
import org.jboss.as.cli.embedded.EmbeddedLogContext;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

class EnvironmentRestorer {
    private final Contexts defaultContexts = new Contexts(LogContext.getLogContext(), StdioContext.getStdioContext());
    private final Map<String, String> propertiesToReset = new HashMap<String, String>();
    private boolean logContextSelectorRestored;

    EnvironmentRestorer(String ... propertyKeys) {
        for (String key : propertyKeys) {
            String value = WildFlySecurityManager.getPropertyPrivileged((String)key, null);
            this.propertiesToReset.put(key, value);
        }
        this.propertiesToReset.put("jboss.home.dir", WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null));
        this.propertiesToReset.put("org.jboss.boot.log.file", WildFlySecurityManager.getPropertyPrivileged((String)"org.jboss.boot.log.file", null));
    }

    Contexts getDefaultContexts() {
        return this.defaultContexts;
    }

    synchronized void restoreLogContextSelector() {
        if (!this.logContextSelectorRestored) {
            final LogContext logContext = this.defaultContexts.getLogContext();
            if (logContext == LogContext.getSystemLogContext()) {
                LogContext.setLogContextSelector((LogContextSelector)LogContext.DEFAULT_LOG_CONTEXT_SELECTOR);
            } else {
                LogContext.setLogContextSelector((LogContextSelector)new LogContextSelector(){

                    public LogContext getLogContext() {
                        return logContext;
                    }
                });
            }
            EmbeddedLogContext.clearLogContext();
            this.logContextSelectorRestored = true;
        }
    }

    void restoreEnvironment() {
        Iterator<Map.Entry<String, String>> iter = this.propertiesToReset.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String value = entry.getValue();
            if (value == null) {
                WildFlySecurityManager.clearPropertyPrivileged((String)entry.getKey());
            } else {
                WildFlySecurityManager.setPropertyPrivileged((String)entry.getKey(), (String)value);
            }
            iter.remove();
        }
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(this.defaultContexts.getStdioContext()));
        this.restoreLogContextSelector();
    }
}

