/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileDeploymentManager {
    private static final String DEFAULT_CONFIGURATION_URL = "broker.xml";
    private final String configurationUrl;
    LinkedHashMap<String, Deployable> deployables = new LinkedHashMap();

    public FileDeploymentManager() {
        this.configurationUrl = DEFAULT_CONFIGURATION_URL;
    }

    public FileDeploymentManager(String configurationUrl) {
        this.configurationUrl = configurationUrl;
    }

    public void readConfiguration() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.configurationUrl);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(this.configurationUrl);
        }
        if (url == null) {
            url = new URL(this.configurationUrl);
        }
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            String xml = XMLUtil.readerToString((Reader)reader);
            xml = XMLUtil.replaceSystemProps((String)xml);
            Element e = XMLUtil.stringToElement((String)xml);
            for (Deployable deployable : this.deployables.values()) {
                String root = deployable.getRootElement();
                NodeList children = e.getElementsByTagName(root);
                if (root == null || children.getLength() <= 0) continue;
                Node item = children.item(0);
                XMLUtil.validate((Node)item, (String)deployable.getSchema());
                deployable.parse((Element)item, url);
            }
        }
    }

    public Map<String, ActiveMQComponent> buildService(ActiveMQSecurityManager securityManager, MBeanServer mBeanServer) throws Exception {
        HashMap<String, ActiveMQComponent> components = new HashMap<String, ActiveMQComponent>();
        for (Deployable deployable : this.deployables.values()) {
            if (!deployable.isParsed()) continue;
            deployable.buildService(securityManager, mBeanServer, this.deployables, components);
        }
        return components;
    }

    public FileDeploymentManager addDeployable(Deployable deployable) {
        this.deployables.put(deployable.getRootElement(), deployable);
        return this;
    }
}

