/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.ObjectInputStreamWithClassLoader;
import org.apache.activemq.artemis.utils.StringEscapeUtils;

public final class JsonUtil {
    public static JsonArray toJSONArray(Object[] array) throws Exception {
        JsonArrayBuilder jsonArray = JsonLoader.createArrayBuilder();
        for (Object parameter : array) {
            if (parameter instanceof Map) {
                Map map = (Map)parameter;
                JsonObjectBuilder jsonObject = JsonLoader.createObjectBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    if (val == null) continue;
                    if (val.getClass().isArray()) {
                        JsonArray objectArray = JsonUtil.toJSONArray((Object[])val);
                        jsonObject.add(key, objectArray);
                        continue;
                    }
                    JsonUtil.addToObject(key, val, jsonObject);
                }
                jsonArray.add(jsonObject);
                continue;
            }
            if (parameter != null) {
                Class<?> clz = parameter.getClass();
                if (clz.isArray()) {
                    Object[] innerArray = (Object[])parameter;
                    if (innerArray instanceof CompositeData[]) {
                        JsonArrayBuilder innerJsonArray = JsonLoader.createArrayBuilder();
                        for (Object data : innerArray) {
                            String s = Base64.encodeObject((CompositeDataSupport)data);
                            innerJsonArray.add(s);
                        }
                        JsonObjectBuilder jsonObjectBuilder = JsonLoader.createObjectBuilder();
                        jsonObjectBuilder.add(CompositeData.class.getName(), innerJsonArray);
                        jsonArray.add(jsonObjectBuilder);
                        continue;
                    }
                    jsonArray.add(JsonUtil.toJSONArray(innerArray));
                    continue;
                }
                JsonUtil.addToArray(parameter, jsonArray);
                continue;
            }
            jsonArray.addNull();
        }
        return jsonArray.build();
    }

    public static Object[] fromJsonArray(JsonArray jsonArray) throws Exception {
        Object[] array = new Object[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object val = jsonArray.get(i);
            if (val instanceof JsonArray) {
                Object[] inner;
                array[i] = inner = JsonUtil.fromJsonArray((JsonArray)val);
                continue;
            }
            if (val instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)val;
                HashMap map = new HashMap();
                Set keys = jsonObject.keySet();
                for (String key : keys) {
                    Object innerVal = jsonObject.get(key);
                    if (innerVal instanceof JsonArray) {
                        innerVal = JsonUtil.fromJsonArray((JsonArray)innerVal);
                    } else if (innerVal instanceof JsonString) {
                        innerVal = ((JsonString)innerVal).getString();
                    } else if (innerVal == JsonValue.FALSE) {
                        innerVal = Boolean.FALSE;
                    } else if (innerVal == JsonValue.TRUE) {
                        innerVal = Boolean.TRUE;
                    } else if (innerVal instanceof JsonNumber) {
                        JsonNumber jsonNumber = (JsonNumber)innerVal;
                        innerVal = jsonNumber.isIntegral() ? (Number)jsonNumber.longValue() : (Number)jsonNumber.doubleValue();
                    } else if (innerVal instanceof JsonObject) {
                        HashMap innerMap = new HashMap();
                        JsonObject o = (JsonObject)innerVal;
                        Set innerKeys = o.keySet();
                        for (String k : innerKeys) {
                            innerMap.put(k, o.get(k));
                        }
                        innerVal = innerMap;
                    }
                    if (CompositeData.class.getName().equals(key)) {
                        Object[] data = (Object[])innerVal;
                        CompositeData[] cds = new CompositeData[data.length];
                        for (int i1 = 0; i1 < data.length; ++i1) {
                            String dataConverted = JsonUtil.convertJsonValue(data[i1], String.class).toString();
                            try (ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(Base64.decode(dataConverted)));){
                                ois.setWhiteList("java.util,java.lang,javax.management");
                                cds[i1] = (CompositeDataSupport)ois.readObject();
                                continue;
                            }
                        }
                        innerVal = cds;
                    }
                    map.put(key, innerVal);
                }
                array[i] = map;
                continue;
            }
            if (val instanceof JsonString) {
                array[i] = ((JsonString)val).getString();
                continue;
            }
            if (val == JsonValue.FALSE) {
                array[i] = Boolean.FALSE;
                continue;
            }
            if (val == JsonValue.TRUE) {
                array[i] = Boolean.TRUE;
                continue;
            }
            if (val instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)val;
                if (jsonNumber.isIntegral()) {
                    array[i] = jsonNumber.longValue();
                    continue;
                }
                array[i] = jsonNumber.doubleValue();
                continue;
            }
            array[i] = val == JsonValue.NULL ? null : val;
        }
        return array;
    }

    public static JsonValue nullSafe(String input) {
        return new NullableJsonString(input);
    }

    public static void addToObject(String key, Object param, JsonObjectBuilder jsonObjectBuilder) {
        if (param instanceof Integer) {
            jsonObjectBuilder.add(key, (Integer)param);
        } else if (param instanceof Long) {
            jsonObjectBuilder.add(key, (Long)param);
        } else if (param instanceof Double) {
            jsonObjectBuilder.add(key, (Double)param);
        } else if (param instanceof String) {
            jsonObjectBuilder.add(key, (String)param);
        } else if (param instanceof Boolean) {
            jsonObjectBuilder.add(key, (Boolean)param);
        } else if (param instanceof Map) {
            JsonObject mapObject = JsonUtil.toJsonObject((Map)param);
            jsonObjectBuilder.add(key, mapObject);
        } else if (param instanceof Short) {
            jsonObjectBuilder.add(key, ((Short)param).shortValue());
        } else if (param instanceof Byte) {
            jsonObjectBuilder.add(key, ((Byte)param).shortValue());
        } else if (param instanceof SimpleString) {
            jsonObjectBuilder.add(key, param.toString());
        } else if (param == null) {
            jsonObjectBuilder.addNull(key);
        } else if (param instanceof byte[]) {
            JsonArrayBuilder byteArrayObject = JsonUtil.toJsonArrayBuilder((byte[])param);
            jsonObjectBuilder.add(key, byteArrayObject);
        } else {
            throw ActiveMQClientMessageBundle.BUNDLE.invalidManagementParam(param.getClass().getName());
        }
    }

    public static void addToArray(Object param, JsonArrayBuilder jsonArrayBuilder) {
        if (param instanceof Integer) {
            jsonArrayBuilder.add((Integer)param);
        } else if (param instanceof Long) {
            jsonArrayBuilder.add((Long)param);
        } else if (param instanceof Double) {
            jsonArrayBuilder.add((Double)param);
        } else if (param instanceof String) {
            jsonArrayBuilder.add((String)param);
        } else if (param instanceof Boolean) {
            jsonArrayBuilder.add((Boolean)param);
        } else if (param instanceof Map) {
            JsonObject mapObject = JsonUtil.toJsonObject((Map)param);
            jsonArrayBuilder.add(mapObject);
        } else if (param instanceof Short) {
            jsonArrayBuilder.add(((Short)param).shortValue());
        } else if (param instanceof Byte) {
            jsonArrayBuilder.add(((Byte)param).shortValue());
        } else if (param == null) {
            jsonArrayBuilder.addNull();
        } else if (param instanceof byte[]) {
            JsonArrayBuilder byteArrayObject = JsonUtil.toJsonArrayBuilder((byte[])param);
            jsonArrayBuilder.add(byteArrayObject);
        } else {
            throw ActiveMQClientMessageBundle.BUNDLE.invalidManagementParam(param.getClass().getName());
        }
    }

    public static JsonArray toJsonArray(List<String> strings) {
        JsonArrayBuilder array = JsonLoader.createArrayBuilder();
        if (strings != null) {
            for (String connector : strings) {
                array.add(connector);
            }
        }
        return array.build();
    }

    public static JsonObject toJsonObject(Map<String, ?> map) {
        JsonObjectBuilder jsonObjectBuilder = JsonLoader.createObjectBuilder();
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                JsonUtil.addToObject(String.valueOf(entry.getKey()), entry.getValue(), jsonObjectBuilder);
            }
        }
        return jsonObjectBuilder.build();
    }

    public static JsonArrayBuilder toJsonArrayBuilder(byte[] byteArray) {
        JsonArrayBuilder jsonArrayBuilder = JsonLoader.createArrayBuilder();
        if (byteArray != null) {
            for (int i = 0; i < byteArray.length; ++i) {
                jsonArrayBuilder.add(Byte.valueOf(byteArray[i]).shortValue());
            }
        }
        return jsonArrayBuilder;
    }

    public static JsonArray readJsonArray(String jsonString) {
        return Json.createReader(new StringReader(jsonString)).readArray();
    }

    public static JsonObject readJsonObject(String jsonString) {
        return Json.createReader(new StringReader(jsonString)).readObject();
    }

    public static Map<String, String> readJsonProperties(String jsonString) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (jsonString != null) {
            JsonUtil.readJsonObject(jsonString).forEach((k, v) -> properties.put((String)k, v.toString()));
        }
        return properties;
    }

    public static Object convertJsonValue(Object jsonValue, Class desiredType) {
        if (jsonValue instanceof JsonNumber) {
            JsonNumber number = (JsonNumber)jsonValue;
            if (desiredType == null || desiredType == Long.class || desiredType == Long.TYPE) {
                return number.longValue();
            }
            if (desiredType == Integer.class || desiredType == Integer.TYPE) {
                return number.intValue();
            }
            if (desiredType == Double.class || desiredType == Double.TYPE) {
                return number.doubleValue();
            }
            return number.longValue();
        }
        if (jsonValue instanceof JsonString) {
            return ((JsonString)jsonValue).getString();
        }
        if (jsonValue instanceof JsonValue) {
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            return jsonValue.toString();
        }
        if (jsonValue instanceof Number) {
            Number jsonNumber = (Number)jsonValue;
            if (desiredType == Integer.TYPE || desiredType == Integer.class) {
                return jsonNumber.intValue();
            }
            if (desiredType == Long.TYPE || desiredType == Long.class) {
                return jsonNumber.longValue();
            }
            if (desiredType == Double.TYPE || desiredType == Double.class) {
                return jsonNumber.doubleValue();
            }
            if (desiredType == Short.TYPE || desiredType == Short.class) {
                return jsonNumber.shortValue();
            }
            return jsonValue;
        }
        if (jsonValue instanceof Object[]) {
            Object[] array = (Object[])jsonValue;
            Object[] result = desiredType != null ? (Object[])Array.newInstance(desiredType, array.length) : array;
            for (int i = 0; i < array.length; ++i) {
                result[i] = JsonUtil.convertJsonValue(array[i], desiredType);
            }
            return result;
        }
        return jsonValue;
    }

    private JsonUtil() {
    }

    private static class NullableJsonString
    implements JsonValue,
    JsonString {
        private final String value;
        private String escape;

        NullableJsonString(String value) {
            this.value = value == null || value.length() == 0 ? null : value;
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return this.value == null ? JsonValue.ValueType.NULL : JsonValue.ValueType.STRING;
        }

        @Override
        public String getString() {
            return this.value;
        }

        @Override
        public CharSequence getChars() {
            return this.getString();
        }

        @Override
        public String toString() {
            if (this.value == null) {
                return null;
            }
            String s = this.escape;
            if (s == null) {
                this.escape = s = '\"' + StringEscapeUtils.escapeString(this.value) + '\"';
            }
            return s;
        }
    }
}

