/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class GSSCredentialSecurityFactory
implements SecurityFactory<GSSKerberosCredential> {
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");
    private static final String KRB5LoginModule = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String IBMKRB5LoginModule = "com.ibm.security.auth.module.Krb5LoginModule";
    public static final Oid KERBEROS_V5;
    public static final Oid SPNEGO;
    private final int minimumRemainingLifetime;
    private final ExceptionSupplier<GSSKerberosCredential, GeneralSecurityException> rawSupplier;
    private volatile GSSKerberosCredential cachedCredential;

    GSSCredentialSecurityFactory(int minimumRemainingLifetime, ExceptionSupplier<GSSKerberosCredential, GeneralSecurityException> rawSupplier) {
        this.minimumRemainingLifetime = minimumRemainingLifetime;
        this.rawSupplier = rawSupplier;
    }

    @Override
    public GSSKerberosCredential create() throws GeneralSecurityException {
        GSSKerberosCredential currentCredentialCredential = this.cachedCredential;
        GSSCredential currentCredential = currentCredentialCredential != null ? currentCredentialCredential.getGssCredential() : null;
        try {
            if (currentCredential != null && currentCredential.getRemainingLifetime() >= this.minimumRemainingLifetime) {
                ElytronMessages.log.tracef("Used cached GSSCredential [%s]", (Object)currentCredential);
                return currentCredentialCredential;
            }
            ElytronMessages.log.tracef("No valid cached credential, obtaining new one...", new Object[0]);
            currentCredentialCredential = this.rawSupplier.get();
            ElytronMessages.log.tracef("Obtained GSSCredentialCredential [%s]", (Object)currentCredentialCredential);
            this.cachedCredential = currentCredentialCredential;
            return currentCredentialCredential;
        }
        catch (GSSException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static GSSCredential wrapCredential(final GSSCredential credential) {
        return new GSSCredential(){

            @Override
            public int getUsage(Oid mech) throws GSSException {
                return credential.getUsage(mech);
            }

            @Override
            public int getUsage() throws GSSException {
                return credential.getUsage();
            }

            @Override
            public int getRemainingLifetime() throws GSSException {
                return credential.getRemainingLifetime();
            }

            @Override
            public int getRemainingInitLifetime(Oid mech) throws GSSException {
                return credential.getRemainingInitLifetime(mech);
            }

            @Override
            public int getRemainingAcceptLifetime(Oid mech) throws GSSException {
                return credential.getRemainingAcceptLifetime(mech);
            }

            @Override
            public GSSName getName(Oid mech) throws GSSException {
                return credential.getName(mech);
            }

            @Override
            public GSSName getName() throws GSSException {
                return credential.getName();
            }

            @Override
            public Oid[] getMechs() throws GSSException {
                return credential.getMechs();
            }

            @Override
            public void dispose() throws GSSException {
            }

            @Override
            public void add(GSSName name, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
                credential.add(name, initLifetime, acceptLifetime, mech, usage);
            }
        };
    }

    static {
        try {
            KERBEROS_V5 = new Oid("1.2.840.113554.1.2.2");
            SPNEGO = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException e) {
            throw new RuntimeException("Unable to initialise Oid", e);
        }
    }

    public static class Builder {
        private boolean built = false;
        private List<Oid> mechanismOids = new ArrayList<Oid>();
        private String principal;
        private File keyTab;
        private boolean isServer;
        private boolean obtainKerberosTicket;
        private int minimumRemainingLifetime;
        private int requestLifetime;
        private boolean debug;
        private boolean wrapGssCredential;
        private boolean checkKeyTab;
        private volatile long lastFailTime = 0L;
        private long failCache = 0L;
        private Map<String, Object> options;

        Builder() {
        }

        public Builder setKeyTab(File keyTab) {
            this.assertNotBuilt();
            this.keyTab = keyTab;
            return this;
        }

        public Builder setIsServer(boolean isServer) {
            this.assertNotBuilt();
            this.isServer = isServer;
            return this;
        }

        public Builder setObtainKerberosTicket(boolean obtainKerberosTicket) {
            this.assertNotBuilt();
            this.obtainKerberosTicket = obtainKerberosTicket;
            return this;
        }

        public Builder setMinimumRemainingLifetime(int minimumRemainingLifetime) {
            this.assertNotBuilt();
            this.minimumRemainingLifetime = minimumRemainingLifetime;
            return this;
        }

        public Builder setRequestLifetime(int requestLifetime) {
            this.assertNotBuilt();
            this.requestLifetime = requestLifetime < 0 ? Integer.MAX_VALUE : requestLifetime;
            return this;
        }

        public Builder addMechanismOid(Oid oid) {
            this.assertNotBuilt();
            this.mechanismOids.add(Assert.checkNotNullParam("oid", oid));
            return this;
        }

        public Builder setPrincipal(String principal) {
            this.assertNotBuilt();
            this.principal = principal;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.assertNotBuilt();
            this.debug = debug;
            return this;
        }

        public Builder setWrapGssCredential(boolean value) {
            this.assertNotBuilt();
            this.wrapGssCredential = value;
            return this;
        }

        public Builder setCheckKeyTab(boolean value) {
            this.assertNotBuilt();
            this.checkKeyTab = value;
            return this;
        }

        public Builder setOptions(Map<String, Object> options) {
            this.assertNotBuilt();
            this.options = options;
            return this;
        }

        public Builder setFailCache(long seconds) {
            this.assertNotBuilt();
            this.failCache = seconds;
            return this;
        }

        public SecurityFactory<GSSKerberosCredential> build() throws IOException {
            this.assertNotBuilt();
            if (this.checkKeyTab) {
                this.checkKeyTab();
            }
            Configuration configuration = this.createConfiguration();
            this.built = true;
            return new GSSCredentialSecurityFactory(this.minimumRemainingLifetime > 0 ? this.minimumRemainingLifetime : 0, () -> this.createGSSCredential(configuration));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GSSKerberosCredential createGSSCredential(Configuration configuration) throws GeneralSecurityException {
            if (this.failCache != 0L && System.currentTimeMillis() - this.lastFailTime < this.failCache * 1000L) {
                throw ElytronMessages.log.initialLoginSkipped(this.failCache);
            }
            Subject subject = new Subject();
            try {
                KerberosTicket kerberosTicket;
                LoginContext lc;
                ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(Builder.class.getClassLoader());
                try {
                    lc = new LoginContext("KDC", subject, c -> {
                        throw new FastUnsupportedCallbackException(c[0]);
                    }, configuration);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(oldCl);
                }
                ElytronMessages.log.tracef("Logging in using LoginContext and subject [%s]", (Object)subject);
                lc.login();
                ElytronMessages.log.tracef("Logging in using LoginContext and subject [%s] succeed", (Object)subject);
                if (this.obtainKerberosTicket) {
                    Set kerberosTickets = AccessController.doPrivileged(() -> subject.getPrivateCredentials(KerberosTicket.class));
                    if (kerberosTickets.size() > 1) {
                        throw ElytronMessages.log.tooManyKerberosTicketsFound();
                    }
                    kerberosTicket = kerberosTickets.size() == 1 ? (KerberosTicket)kerberosTickets.iterator().next() : null;
                } else {
                    kerberosTicket = null;
                }
                GSSManager manager = GSSManager.getInstance();
                return Subject.doAs(subject, () -> {
                    Set<KerberosPrincipal> principals = subject.getPrincipals(KerberosPrincipal.class);
                    if (principals.size() < 1) {
                        throw ElytronMessages.log.noKerberosPrincipalsFound();
                    }
                    if (principals.size() > 1) {
                        throw ElytronMessages.log.tooManyKerberosPrincipalsFound();
                    }
                    KerberosPrincipal principal = principals.iterator().next();
                    ElytronMessages.log.tracef("Creating GSSName for Principal '%s'", (Object)principal);
                    GSSName name = manager.createName(principal.getName(), GSSName.NT_USER_NAME, KERBEROS_V5);
                    if (this.wrapGssCredential) {
                        return new GSSKerberosCredential(GSSCredentialSecurityFactory.wrapCredential(manager.createCredential(name, this.requestLifetime, this.mechanismOids.toArray(new Oid[this.mechanismOids.size()]), this.isServer ? 2 : 1)), kerberosTicket);
                    }
                    return new GSSKerberosCredential(manager.createCredential(name, this.requestLifetime, this.mechanismOids.toArray(new Oid[this.mechanismOids.size()]), this.isServer ? 2 : 1), kerberosTicket);
                });
            }
            catch (LoginException e) {
                if (this.failCache != 0L) {
                    this.lastFailTime = System.currentTimeMillis();
                }
                throw ElytronMessages.log.unableToPerformInitialLogin(e);
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof GeneralSecurityException) {
                    throw (GeneralSecurityException)e.getCause();
                }
                throw new GeneralSecurityException(e.getCause());
            }
        }

        private void checkKeyTab() throws IOException {
            KeyTab kt = KeyTab.getInstance(this.keyTab);
            if (!kt.exists()) {
                throw ElytronMessages.log.keyTabDoesNotExists(this.keyTab.getAbsolutePath());
            }
            if (kt.getKeys(new KerberosPrincipal(this.principal)).length == 0) {
                throw ElytronMessages.log.noKeysForPrincipalInKeyTab(this.principal, this.keyTab.getAbsolutePath());
            }
        }

        private Configuration createConfiguration() throws IOException {
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (this.debug) {
                options.put("debug", "true");
            }
            options.put("principal", this.principal);
            if (IS_IBM) {
                options.put("noAddress", "true");
                options.put("credsType", this.isServer && !this.obtainKerberosTicket ? "acceptor" : "both");
                if (this.keyTab != null) {
                    options.put("useKeytab", this.keyTab.toURI().toURL().toString());
                }
            } else {
                options.put("storeKey", "true");
                options.put("useKeyTab", "true");
                if (this.keyTab != null) {
                    options.put("keyTab", this.keyTab.getAbsolutePath());
                }
                options.put("isInitiator", this.isServer && !this.obtainKerberosTicket ? "false" : "true");
            }
            if (this.options != null) {
                options.putAll(this.options);
            }
            ElytronMessages.log.tracef("Created LoginContext configuration: %s", (Object)((Object)options).toString());
            final AppConfigurationEntry[] aceArray = new AppConfigurationEntry[]{new AppConfigurationEntry(IS_IBM ? GSSCredentialSecurityFactory.IBMKRB5LoginModule : GSSCredentialSecurityFactory.KRB5LoginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            return new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    assert ("KDC".equals(name));
                    return aceArray;
                }
            };
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

