/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.migration.wfly10.config.management.ManageableResource;

public class ManageableResourceType {
    private final Class<? extends ManageableResource> type;
    private final Set<ManageableResourceType> childTypes;
    private volatile Set<ManageableResourceType> descendantTypes;

    protected ManageableResourceType(Class<? extends ManageableResource> type) {
        this.type = Objects.requireNonNull(type);
        this.childTypes = new HashSet<ManageableResourceType>();
    }

    protected ManageableResourceType(Class<? extends ManageableResource> type, ManageableResourceType ... childTypes) {
        this(type);
        for (ManageableResourceType childType : childTypes) {
            this.addChildType(childType);
        }
    }

    protected void addChildType(ManageableResourceType childType) {
        this.childTypes.add(childType);
        this.descendantTypes = null;
    }

    public Class<? extends ManageableResource> getType() {
        return this.type;
    }

    public Set<ManageableResourceType> getChildTypes() {
        return Collections.unmodifiableSet(this.childTypes);
    }

    public Set<ManageableResourceType> getDescendantTypes() {
        if (this.descendantTypes == null) {
            this.descendantTypes = this.findDescendantTypes();
        }
        return this.descendantTypes;
    }

    private synchronized Set<ManageableResourceType> findDescendantTypes() {
        return this.childTypes.stream().flatMap(childType -> Stream.concat(Stream.of(childType), childType.getDescendantTypes().stream())).collect(Collectors.toSet());
    }

    public String toString() {
        return this.getType().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManageableResourceType that = (ManageableResourceType)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

