/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.SimpleComponentTask;
import org.jboss.migration.core.task.component.SimpleComponentTaskBuilder;

public class InitializeTargetDirs {
    protected final SimpleComponentTask.Builder builder;
    protected final List<SimpleComponentTaskBuilder> subtasks;

    public InitializeTargetDirs(String targetDirsName) {
        this.builder = (SimpleComponentTask.Builder)((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name("initialize-target-" + targetDirsName + "-dirs")).beforeRun(context -> context.getLogger().debugf("Initializing target's %s dirs....", (Object)targetDirsName))).afterRun(context -> {
            if (context.hasSucessfulSubtasks()) {
                context.getLogger().infof("Target's %s dirs initialized.", (Object)targetDirsName);
            }
        });
        this.subtasks = new ArrayList<SimpleComponentTaskBuilder>();
    }

    public InitializeTargetDirs targetDir(String name, Path targetDir, Path defaultTargetDir) {
        SimpleComponentTask.BaseBuilder subtask = ((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(new ServerMigrationTaskName.Builder("initialize-target-dir").addAttribute("name", name).build())).skipPolicy(context -> Files.isDirectory(targetDir, new LinkOption[0]))).beforeRun(context -> context.getLogger().debugf("Initializing target dir %s...", (Object)targetDir))).runnable(context -> {
            if (defaultTargetDir != null) {
                context.getMigrationFiles().copy(defaultTargetDir, targetDir);
            } else {
                try {
                    Files.createDirectories(targetDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ServerMigrationFailureException((Throwable)e);
                }
            }
            context.getLogger().debugf("Target's dir %s initialized.", (Object)targetDir);
            return ServerMigrationTaskResult.SUCCESS;
        });
        this.subtasks.add((SimpleComponentTaskBuilder)subtask);
        return this;
    }

    public ServerMigrationTask build() {
        return ((SimpleComponentTask.Builder)this.builder.subtasks(this.subtasks.toArray(new SimpleComponentTaskBuilder[this.subtasks.size()]))).build();
    }
}

