/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.EESubsystemModel;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.ManagedExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedScheduledExecutorServiceResourceDefinition;
import org.jboss.dmr.ModelNode;

public class EETransformers
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "ee";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystem) {
        ModelVersion v1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
        ModelVersion v1_1_0 = ModelVersion.create((int)1, (int)1, (int)0);
        ModelVersion v3_0_0 = ModelVersion.create((int)3, (int)0, (int)0);
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystem.getCurrentSubsystemVersion());
        ResourceTransformationDescriptionBuilder builder_3_0 = chainedBuilder.createBuilder(subsystem.getCurrentSubsystemVersion(), v3_0_0);
        ManagedExecutorServiceResourceDefinition.INSTANCE.registerTransformers_4_0(builder_3_0);
        ManagedScheduledExecutorServiceResourceDefinition.INSTANCE.registerTransformers_4_0(builder_3_0);
        ResourceTransformationDescriptionBuilder builder11 = chainedBuilder.createBuilder(v3_0_0, v1_1_0);
        builder11.rejectChildResource(PathElement.pathElement((String)"context-service"));
        builder11.rejectChildResource(PathElement.pathElement((String)"managed-thread-factory"));
        builder11.rejectChildResource(PathElement.pathElement((String)"managed-executor-service"));
        builder11.rejectChildResource(PathElement.pathElement((String)"managed-scheduled-executor-service"));
        builder11.discardChildResource(EESubsystemModel.DEFAULT_BINDINGS_PATH);
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(v1_1_0, v1_0_0);
        GlobalModulesRejecterConverter globalModulesRejecterConverter = new GlobalModulesRejecterConverter();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)globalModulesRejecterConverter, new AttributeDefinition[]{GlobalModulesDefinition.INSTANCE})).setValueConverter((AttributeConverter)globalModulesRejecterConverter, new AttributeDefinition[]{GlobalModulesDefinition.INSTANCE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT});
        chainedBuilder.buildAndRegister(subsystem, (ModelVersion[][])new ModelVersion[][]{{v1_0_0, v1_1_0, v3_0_0}});
    }

    private static class GlobalModulesRejecterConverter
    extends RejectAttributeChecker.DefaultRejectAttributeChecker
    implements AttributeConverter {
        private final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");

        private GlobalModulesRejecterConverter() {
        }

        public void convertOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            this.cleanModel(attributeValue);
        }

        public void convertResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            this.cleanModel(attributeValue);
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode node : attributeValue.asList()) {
                    ModelNode metaInf;
                    ModelNode services;
                    ModelNode annotations;
                    if (node.hasDefined("annotations") && (this.EXPRESSION_PATTERN.matcher((annotations = node.get("annotations")).asString()).matches() || annotations.asBoolean())) {
                        return true;
                    }
                    if (node.hasDefined("services") && (this.EXPRESSION_PATTERN.matcher((services = node.get("services")).asString()).matches() || !services.asBoolean())) {
                        return true;
                    }
                    if (!node.hasDefined("meta-inf") || !this.EXPRESSION_PATTERN.matcher((metaInf = node.get("meta-inf")).asString()).matches() && !metaInf.asBoolean()) continue;
                    return true;
                }
            }
            return false;
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return EeLogger.ROOT_LOGGER.propertiesNotAllowedOnGlobalModules();
        }

        private void cleanModel(ModelNode attributeValue) {
            if (attributeValue.isDefined()) {
                for (ModelNode node : attributeValue.asList()) {
                    node.remove("annotations");
                    node.remove("services");
                    node.remove("meta-inf");
                }
            }
        }
    }
}

