/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v53;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.AbstractRegionFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.SecondLevelCacheLogger;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.hibernate.cache.commons.DataType;
import org.infinispan.hibernate.cache.commons.DefaultCacheManagerProvider;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.commons.TimeSource;
import org.infinispan.hibernate.cache.commons.util.CacheCommandFactory;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.spi.EmbeddedCacheManagerProvider;
import org.infinispan.hibernate.cache.spi.InfinispanProperties;
import org.infinispan.hibernate.cache.v53.impl.ClusteredTimestampsRegionImpl;
import org.infinispan.hibernate.cache.v53.impl.DomainDataRegionImpl;
import org.infinispan.hibernate.cache.v53.impl.QueryResultsRegionImpl;
import org.infinispan.hibernate.cache.v53.impl.Sync;
import org.infinispan.hibernate.cache.v53.impl.TimestampsRegionImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.TransactionMode;

public class InfinispanRegionFactory
implements RegionFactory,
TimeSource,
InfinispanProperties {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InfinispanRegionFactory.class);
    protected final Map<String, String> baseConfigurations = new HashMap<String, String>();
    protected final Map<String, ConfigurationBuilder> configOverrides = new HashMap<String, ConfigurationBuilder>();
    private CacheKeysFactory cacheKeysFactory;
    private final Map<DataType, Configuration> dataTypeConfigurations = new HashMap<DataType, Configuration>();
    private EmbeddedCacheManager manager;
    private List<InfinispanBaseRegion> regions = new ArrayList<InfinispanBaseRegion>();
    private SessionFactoryOptions settings;
    private Boolean globalStats;

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
        this();
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        log.debugf("Building domain data region [%s] entities=%s collections=%s naturalIds=%s", new Object[]{regionConfig.getRegionName(), regionConfig.getEntityCaching(), regionConfig.getCollectionCaching(), regionConfig.getNaturalIdCaching()});
        int entities = regionConfig.getEntityCaching().size();
        int collections = regionConfig.getCollectionCaching().size();
        int naturalIds = regionConfig.getNaturalIdCaching().size();
        DataType dataType = entities > 0 && collections == 0 && naturalIds == 0 ? (regionConfig.getEntityCaching().stream().allMatch(c -> !c.isMutable()) ? DataType.IMMUTABLE_ENTITY : DataType.ENTITY) : (entities == 0 && collections > 0 && naturalIds == 0 ? DataType.COLLECTION : (entities == 0 && collections == 0 && naturalIds > 0 ? DataType.NATURAL_ID : DataType.ENTITY));
        AdvancedCache cache = this.getCache(this.qualify(regionConfig.getRegionName()), regionConfig.getRegionName(), dataType, Collections.emptyList());
        DomainDataRegionImpl region = new DomainDataRegionImpl(cache, regionConfig, this, this.getCacheKeysFactory());
        this.startRegion(region);
        return region;
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, SessionFactoryImplementor sessionFactory) {
        log.debugf("Building query results cache region [%s]", (Object)regionName);
        List<String> legacyUnqualifiedNames = regionName.equals("default-query-results-region") ? AbstractRegionFactory.LEGACY_QUERY_RESULTS_REGION_UNQUALIFIED_NAMES : Collections.emptyList();
        AdvancedCache cache = this.getCache(this.qualify(regionName), regionName, DataType.QUERY, legacyUnqualifiedNames);
        QueryResultsRegionImpl region = new QueryResultsRegionImpl(cache, regionName, this);
        this.startRegion(region);
        return region;
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, SessionFactoryImplementor sessionFactory) {
        log.debugf("Building timestamps cache region [%s]", (Object)regionName);
        List<String> legacyUnqualifiedNames = regionName.equals("default-update-timestamps-region") ? AbstractRegionFactory.LEGACY_UPDATE_TIMESTAMPS_REGION_UNQUALIFIED_NAMES : Collections.emptyList();
        AdvancedCache cache = this.getCache(this.qualify(regionName), regionName, DataType.TIMESTAMPS, legacyUnqualifiedNames);
        TimestampsRegionImpl region = this.createTimestampsRegion(cache, regionName);
        this.startRegion(region);
        return region;
    }

    protected TimestampsRegionImpl createTimestampsRegion(AdvancedCache cache, String regionName) {
        if (Caches.isClustered((AdvancedCache)cache)) {
            return new ClusteredTimestampsRegionImpl(cache, regionName, this);
        }
        return new TimestampsRegionImpl(cache, regionName, this);
    }

    public Configuration getPendingPutsCacheConfiguration() {
        return this.dataTypeConfigurations.get(DataType.PENDING_PUTS);
    }

    protected CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public String qualify(String regionName) {
        return RegionNameQualifier.INSTANCE.qualify(regionName, this.settings);
    }

    public CacheTransactionSynchronization createTransactionContext(SharedSessionContractImplementor session) {
        return new Sync(this);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis();
    }

    public void setCacheManager(EmbeddedCacheManager manager) {
        this.manager = manager;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public void start(SessionFactoryOptions settings, Map configValues) throws CacheException {
        log.debug((Object)"Starting Infinispan region factory");
        this.cacheKeysFactory = this.determineCacheKeysFactory(settings, configValues);
        try {
            this.settings = settings;
            for (Object k : configValues.keySet()) {
                String key = (String)k;
                int prefixLoc = key.indexOf("hibernate.cache.infinispan.");
                if (prefixLoc == -1) continue;
                this.parseProperty(prefixLoc, key, this.extractProperty(key, configValues));
            }
            String globalStatsStr = this.extractProperty("hibernate.cache.infinispan.statistics", configValues);
            if (globalStatsStr != null) {
                this.globalStats = Boolean.parseBoolean(globalStatsStr);
            }
            if (configValues.containsKey("hibernate.cache.infinispan.use_synchronization")) {
                log.propertyUseSynchronizationDeprecated();
            }
            StandardServiceRegistry serviceRegistry = settings.getServiceRegistry();
            this.manager = this.createCacheManager(this.toProperties(configValues), (ServiceRegistry)serviceRegistry);
            this.defineDataTypeCacheConfigurations((ServiceRegistry)serviceRegistry);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw log.unableToStart(t);
        }
    }

    private Properties toProperties(Map<Object, Object> configValues) {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : configValues.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    private CacheKeysFactory determineCacheKeysFactory(SessionFactoryOptions settings, Map properties) {
        return (CacheKeysFactory)((StrategySelector)settings.getServiceRegistry().getService(StrategySelector.class)).resolveDefaultableStrategy(CacheKeysFactory.class, properties.get("hibernate.cache.keys_factory"), (Object)DefaultCacheKeysFactory.INSTANCE);
    }

    protected EmbeddedCacheManager createCacheManager(Properties properties, ServiceRegistry serviceRegistry) {
        for (EmbeddedCacheManagerProvider provider : ServiceLoader.load(EmbeddedCacheManagerProvider.class, EmbeddedCacheManagerProvider.class.getClassLoader())) {
            EmbeddedCacheManager cacheManager = provider.getEmbeddedCacheManager(properties);
            if (cacheManager == null) continue;
            return cacheManager;
        }
        return new DefaultCacheManagerProvider(serviceRegistry).getEmbeddedCacheManager(properties);
    }

    public void stop() {
        log.debug((Object)"Stop region factory");
        this.stopCacheRegions();
        this.stopCacheManager();
    }

    protected void stopCacheRegions() {
        log.debug((Object)"Clear region references");
        this.getCacheCommandFactory().clearRegions(this.regions);
        this.regions.forEach(region -> {
            region.destroy();
            this.manager.undefineConfiguration(region.getCache().getName());
        });
        this.regions.clear();
    }

    protected void stopCacheManager() {
        log.debug((Object)"Stop cache manager");
        this.manager.stop();
    }

    private ConfigurationBuilderHolder loadConfiguration(ServiceRegistry serviceRegistry, String configFile) {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        ClassLoader infinispanClassLoader = InfinispanRegionFactory.class.getClassLoader();
        return (ConfigurationBuilderHolder)((ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class)).workWithClassLoader(classLoader -> {
            ConfigurationBuilderHolder configurationBuilderHolder;
            InputStream is = null;
            try {
                ConfigurationBuilderHolder holder;
                is = fileLookup.lookupFile(configFile, classLoader);
                if (is == null) {
                    classLoader = infinispanClassLoader;
                    is = FileLookupFactory.newInstance().lookupFileStrict(configFile, classLoader);
                }
                ParserRegistry parserRegistry = new ParserRegistry(infinispanClassLoader);
                configurationBuilderHolder = holder = InfinispanRegionFactory.parseWithOverridenClassLoader(parserRegistry, is, infinispanClassLoader);
            }
            catch (IOException e) {
                try {
                    throw log.unableToCreateCacheManager((Throwable)e);
                }
                catch (Throwable throwable) {
                    Util.close(is);
                    throw throwable;
                }
            }
            Util.close((AutoCloseable)is);
            return configurationBuilderHolder;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationBuilderHolder parseWithOverridenClassLoader(ParserRegistry configurationParser, InputStream is, ClassLoader infinispanClassLoader) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(infinispanClassLoader);
            ConfigurationBuilderHolder builderHolder = configurationParser.parse(is);
            builderHolder.getGlobalConfigurationBuilder().classLoader(infinispanClassLoader);
            ConfigurationBuilderHolder configurationBuilderHolder = builderHolder;
            return configurationBuilderHolder;
        }
        finally {
            currentThread.setContextClassLoader(originalContextClassLoader);
        }
    }

    private void startRegion(InfinispanBaseRegion region) {
        this.regions.add(region);
        this.getCacheCommandFactory().addRegion(region);
    }

    private void parseProperty(int prefixLoc, String key, String value) {
        int suffixLoc = key.indexOf(".cfg");
        if (suffixLoc != -1 && !key.equals("hibernate.cache.infinispan.cfg")) {
            String regionName = key.substring(prefixLoc + "hibernate.cache.infinispan.".length(), suffixLoc);
            this.baseConfigurations.put(regionName, value);
        } else if (key.contains(".eviction.strategy")) {
            log.ignoringDeprecatedProperty(".eviction.strategy");
        } else {
            suffixLoc = key.indexOf(".expiration.wake_up_interval");
            if (suffixLoc != -1 || (suffixLoc = key.indexOf(".eviction.wake_up_interval")) != -1) {
                ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                builder.expiration().wakeUpInterval(Long.parseLong(value));
            } else {
                suffixLoc = key.indexOf(".memory.size");
                if (suffixLoc != -1) {
                    ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                    builder.memory().size(Long.parseLong(value));
                } else {
                    suffixLoc = key.indexOf(".eviction.max_entries");
                    if (suffixLoc != -1) {
                        log.deprecatedProperty(".eviction.max_entries", ".memory.size");
                        ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                        builder.memory().size(Long.parseLong(value));
                    } else {
                        suffixLoc = key.indexOf(".expiration.lifespan");
                        if (suffixLoc != -1) {
                            ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                            builder.expiration().lifespan(Long.parseLong(value));
                        } else {
                            suffixLoc = key.indexOf(".expiration.max_idle");
                            if (suffixLoc != -1) {
                                ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                                builder.expiration().maxIdle(Long.parseLong(value));
                            }
                        }
                    }
                }
            }
        }
    }

    private String extractProperty(String key, Map properties) {
        String value = ConfigurationHelper.extractPropertyValue((String)key, (Map)properties);
        log.debugf("Configuration override via property %s: %s", (Object)key, (Object)value);
        return value;
    }

    private ConfigurationBuilder getOrCreateConfig(int prefixLoc, String key, int suffixLoc) {
        String name = key.substring(prefixLoc + "hibernate.cache.infinispan.".length(), suffixLoc);
        return this.configOverrides.computeIfAbsent(name, Void2 -> new ConfigurationBuilder());
    }

    private void defineDataTypeCacheConfigurations(ServiceRegistry serviceRegistry) {
        String defaultResource = this.manager.getCacheManagerConfiguration().isClustered() ? "org/infinispan/hibernate/cache/commons/builder/infinispan-configs.xml" : "org/infinispan/hibernate/cache/commons/builder/infinispan-configs-local.xml";
        ConfigurationBuilderHolder defaultConfiguration = DefaultCacheManagerProvider.loadConfiguration((ServiceRegistry)serviceRegistry, (String)defaultResource);
        for (DataType type : DataType.values()) {
            ConfigurationBuilder override;
            ConfigurationBuilder builder;
            Configuration configuration;
            String cacheName = this.baseConfigurations.get(type.key);
            if (cacheName == null) {
                cacheName = type.defaultCacheName;
            }
            if ((configuration = this.manager.getCacheConfiguration(cacheName)) == null) {
                log.debugf("Cache configuration not found for %s", (Object)type);
                if (!cacheName.equals(type.defaultCacheName)) {
                    log.customConfigForTypeNotFound(cacheName, type.key);
                }
                if ((builder = (ConfigurationBuilder)defaultConfiguration.getNamedConfigurationBuilders().get(type.defaultCacheName)) == null) {
                    throw new IllegalStateException("Generic data types must have default configuration, none found for " + type);
                }
            } else {
                builder = new ConfigurationBuilder().read(configuration);
            }
            if ((override = this.configOverrides.get(type.key)) != null) {
                builder.read(override.build(false));
            }
            builder.template(true);
            this.unsetTransactions(builder);
            this.dataTypeConfigurations.put(type, builder.build());
        }
    }

    protected AdvancedCache getCache(String cacheName, String unqualifiedRegionName, DataType type, Collection<String> legacyUnqualifiedNames) {
        AdvancedCache cache;
        if (!this.manager.cacheExists(cacheName)) {
            ConfigurationBuilder override;
            Configuration configuration;
            String templateCacheName = this.baseConfigurations.get(cacheName);
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (templateCacheName == null && (templateCacheName = this.baseConfigurations.get(unqualifiedRegionName)) != null) {
                log.usingUnqualifiedNameInConfiguration(unqualifiedRegionName, cacheName);
            }
            if (templateCacheName != null) {
                configuration = this.manager.getCacheConfiguration(templateCacheName);
                if (configuration == null) {
                    log.customConfigForRegionNotFound(templateCacheName, cacheName, type.key);
                } else {
                    log.debugf("Region '%s' will use cache template '%s'", (Object)cacheName, (Object)templateCacheName);
                    builder.read(configuration);
                    this.unsetTransactions(builder);
                    if (templateCacheName.equals(cacheName)) {
                        this.manager.undefineConfiguration(cacheName);
                    }
                }
            } else {
                configuration = this.manager.getCacheConfiguration(cacheName);
                if (configuration != null) {
                    log.regionNameMatchesCacheName(cacheName, cacheName, cacheName);
                    this.manager.undefineConfiguration(cacheName);
                }
                if (this.manager.getCacheConfiguration(unqualifiedRegionName) != null) {
                    log.configurationWithUnqualifiedName(unqualifiedRegionName, cacheName);
                }
            }
            for (String legacyUnqualified : legacyUnqualifiedNames) {
                configuration = this.manager.getCacheConfiguration(this.qualify(legacyUnqualified));
                if (configuration != null) {
                    SecondLevelCacheLogger.INSTANCE.usingLegacyCacheName(cacheName, this.qualify(legacyUnqualified));
                    break;
                }
                configuration = this.manager.getCacheConfiguration(legacyUnqualified);
                if (configuration == null) continue;
                SecondLevelCacheLogger.INSTANCE.usingLegacyCacheName(cacheName, legacyUnqualified);
                break;
            }
            if (configuration == null) {
                configuration = this.dataTypeConfigurations.get(type);
                if (configuration == null) {
                    throw new IllegalStateException("Configuration not defined for type " + type.key);
                }
                builder.read(configuration);
            }
            if ((override = this.configOverrides.get(cacheName)) != null) {
                log.debugf("Region '%s' has additional configuration set through properties.", (Object)cacheName);
                builder.read(override.build(false));
            }
            if (this.globalStats != null) {
                builder.jmxStatistics().enabled(this.globalStats.booleanValue()).available(this.globalStats.booleanValue());
            }
            configuration = builder.build();
            type.validate(configuration);
            this.manager.defineConfiguration(cacheName, configuration);
        }
        if (!(cache = this.manager.getCache(cacheName).getAdvancedCache()).getStatus().allowInvocations()) {
            cache.start();
        }
        return cache;
    }

    private void unsetTransactions(ConfigurationBuilder builder) {
        if (builder.transaction().transactionMode().isTransactional()) {
            log.transactionalConfigurationIgnored();
            builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).transactionManagerLookup(null);
        }
    }

    private CacheCommandFactory getCacheCommandFactory() {
        GlobalComponentRegistry globalCr = this.manager.getGlobalComponentRegistry();
        Map factories = (Map)globalCr.getComponent("org.infinispan.modules.command.factories");
        for (ModuleCommandFactory factory : factories.values()) {
            if (!(factory instanceof CacheCommandFactory)) continue;
            return (CacheCommandFactory)factory;
        }
        throw log.cannotInstallCommandFactory();
    }
}

