/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryStatisticsService;

public class PooledConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final PooledConnectionFactoryAdd INSTANCE = new PooledConnectionFactoryAdd();

    private PooledConnectionFactoryAdd() {
        super(ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress dgAddress;
        Resource dgResource;
        ModelNode dgModel;
        ModelNode jgroupCluster;
        String txType;
        ModelNode model = resource.getModel();
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        ModelNode resolvedModel = model.clone();
        for (AttributeDefinition attribute : ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES)) {
            resolvedModel.get(attribute.getName()).set(attribute.resolveModelAttribute(context, resolvedModel));
        }
        ArrayList<String> jndiNames = new ArrayList<String>();
        for (ModelNode node : resolvedModel.get(ConnectionFactoryAttributes.Common.ENTRIES.getName()).asList()) {
            jndiNames.add(node.asString());
        }
        String managedConnectionPoolClassName = null;
        if (resolvedModel.hasDefined(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName())) {
            managedConnectionPoolClassName = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()).asString();
        }
        int minPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).asInt();
        int maxPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).asInt();
        Boolean enlistmentTrace = null;
        if (resolvedModel.hasDefined(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName())) {
            enlistmentTrace = resolvedModel.get(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName()).asBoolean();
        }
        String txSupport = resolvedModel.hasDefined(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()) ? ("local".equals(txType = resolvedModel.get(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()).asString()) ? "LocalTransaction" : ("none".equals(txType) ? "NoTransaction" : "XATransaction")) : "XATransaction";
        List connectors = ConnectionFactoryAttributes.Common.CONNECTORS.unwrap((ExpressionResolver)context, model);
        String discoveryGroupName = PooledConnectionFactoryAdd.getDiscoveryGroup(resolvedModel);
        String jgroupClusterName = null;
        String jgroupsChannelName = null;
        PathAddress serverAddress = MessagingServices.getActiveMQServerPathAddress(address);
        if (discoveryGroupName != null && (jgroupCluster = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, dgModel = (dgResource = context.readResourceFromRoot(dgAddress = PooledConnectionFactoryAdd.isSubsystemResource(context) ? address.getParent().append("discovery-group", discoveryGroupName) : serverAddress.append("discovery-group", discoveryGroupName), false)).getModel())).isDefined()) {
            jgroupClusterName = jgroupCluster.asString();
            ModelNode channel = DiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, dgModel);
            if (channel.isDefined()) {
                jgroupsChannelName = channel.asString();
            }
        }
        List<PooledConnectionFactoryConfigProperties> adapterParams = PooledConnectionFactoryAdd.getAdapterParams(resolvedModel, context);
        if (PooledConnectionFactoryAdd.isSubsystemResource(context)) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = null;
            if (discoveryGroupName != null) {
                discoveryGroupConfiguration = ExternalConnectionFactoryAdd.getDiscoveryGroup(context, discoveryGroupName);
            }
            HashSet<String> connectorsSocketBindings = new HashSet<String>();
            TransportConfiguration[] transportConfigurations = TransportConfigOperationHandlers.processConnectors(context, connectors, connectorsSocketBindings);
            ExternalPooledConnectionFactoryService.installService(context, name, transportConfigurations, discoveryGroupConfiguration, connectorsSocketBindings, jgroupClusterName, jgroupsChannelName, adapterParams, jndiNames, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, model);
        } else {
            String serverName = serverAddress.getLastElement().getValue();
            PooledConnectionFactoryService.installService(context, name, serverName, (List<String>)connectors, discoveryGroupName, jgroupClusterName, adapterParams, jndiNames, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, model);
        }
        boolean statsEnabled = ConnectionFactoryAttributes.Pooled.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (statsEnabled) {
            PooledConnectionFactoryStatisticsService.registerStatisticsResources(resource);
            this.installStatistics(context, name);
        }
    }

    private static boolean isSubsystemResource(OperationContext context) {
        return "subsystem".equals(context.getCurrentAddress().getParent().getLastElement().getKey());
    }

    static String getTxSupport(ModelNode resolvedModel) {
        String txType;
        switch (txType = resolvedModel.get(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()).asStringOrNull()) {
            case "local": {
                return "LocalTransaction";
            }
            case "none": {
                return "NoTransaction";
            }
        }
        return "XATransaction";
    }

    static String getDiscoveryGroup(ModelNode model) {
        if (model.hasDefined(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName())) {
            return model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()).asString();
        }
        return null;
    }

    static List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model, OperationContext context) throws OperationFailedException {
        ArrayList<PooledConnectionFactoryConfigProperties> configs = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (ConnectionFactoryAttribute nodeAttribute : PooledConnectionFactoryDefinition.ATTRIBUTES) {
            AttributeDefinition definition;
            ModelNode node;
            if (!nodeAttribute.isResourceAdapterProperty() || !(node = (definition = nodeAttribute.getDefinition()).resolveModelAttribute(context, model)).isDefined()) continue;
            String attributeName = definition.getName();
            String value = attributeName.equals(ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.getName()) ? String.join((CharSequence)",", ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.unwrap((ExpressionResolver)context, model)) : (attributeName.equals(ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.getName()) ? String.join((CharSequence)",", ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.unwrap((ExpressionResolver)context, model)) : node.asString());
            configs.add(new PooledConnectionFactoryConfigProperties(nodeAttribute.getPropertyName(), value, nodeAttribute.getClassType(), nodeAttribute.getConfigType()));
        }
        return configs;
    }

    private void installStatistics(OperationContext context, String name) {
        ServiceName raActivatorsServiceName = PooledConnectionFactoryService.getResourceAdapterActivatorsServiceName(name);
        PooledConnectionFactoryStatisticsService statsService = new PooledConnectionFactoryStatisticsService(context.getResourceRegistrationForUpdate(), true);
        context.getServiceTarget().addService(raActivatorsServiceName.append(new String[]{"statistics"}), (Service)statsService).addDependency(raActivatorsServiceName, ResourceAdapterDeployment.class, statsService.getRADeploymentInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }
}

