/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Arrays;
import org.wildfly.discovery.AttributeValue;

final class OpaqueAttributeValue
extends AttributeValue {
    private static final long serialVersionUID = -4002474273921497373L;
    private final byte[] content;
    private transient int hashCode;

    OpaqueAttributeValue(byte[] content, boolean clone) {
        this.content = clone ? (byte[])content.clone() : content;
    }

    @Override
    int getKind() {
        return 0;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public int compareTo(AttributeValue other) {
        if (other instanceof OpaqueAttributeValue) {
            return OpaqueAttributeValue.compareArrays(this.content, ((OpaqueAttributeValue)other).content);
        }
        return super.compareTo(other);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof OpaqueAttributeValue && this.equals((OpaqueAttributeValue)obj);
    }

    @Override
    public boolean equals(AttributeValue obj) {
        return obj instanceof OpaqueAttributeValue && this.equals((OpaqueAttributeValue)obj);
    }

    public boolean equals(OpaqueAttributeValue obj) {
        return obj == this || obj != null && this.hashCode() == obj.hashCode() && Arrays.equals(this.content, obj.content);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = Arrays.hashCode(this.content);
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    private static int compareArrays(byte[] a1, byte[] a2) {
        int l1 = a1.length;
        int l2 = a2.length;
        int minLen = Math.min(l1, l2);
        for (int i = 0; i < minLen; ++i) {
            int res = Integer.signum((a1[i] & 0xFF) - (a2[i] & 0xFF));
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(l1 - l2);
    }

    @Override
    String generateToString() {
        StringBuilder builder = new StringBuilder(this.content.length * 2);
        for (byte b : this.content) {
            int l = b & 0xF;
            int h = (b & 0xF0) >> 4;
            builder.append('\\');
            if (h < 10) {
                builder.append(48 + h);
            } else {
                builder.append(65 + h - 10);
            }
            if (l < 10) {
                builder.append(48 + l);
                continue;
            }
            builder.append(65 + l - 10);
        }
        return builder.toString();
    }
}

