/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.MechanismInformationCallback;
import org.wildfly.security.auth.server.MechanismInformation;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerRequest;

public class SetMechanismInformationMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private HttpServerAuthenticationMechanismFactory delegate;

    public SetMechanismInformationMechanismFactory(HttpServerAuthenticationMechanismFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(properties);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, final CallbackHandler callbackHandler) throws HttpAuthenticationException {
        final HttpServerAuthenticationMechanism mechanism = this.delegate.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
        return mechanism != null ? new HttpServerAuthenticationMechanism(){

            @Override
            public String getMechanismName() {
                return mechanism.getMechanismName();
            }

            @Override
            public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
                String host = request.getFirstRequestHeaderValue("Host");
                String resolvedHostName = null;
                if (host != null) {
                    if (host.startsWith("[")) {
                        int close = host.indexOf(93);
                        if (close > 0) {
                            resolvedHostName = host.substring(0, close + 1);
                        }
                    } else {
                        int colon = host.lastIndexOf(58);
                        resolvedHostName = colon > 0 ? host.substring(0, colon) : host;
                    }
                }
                try {
                    final String mechanismName = this.getMechanismName();
                    final String hostName = resolvedHostName;
                    final String protocol = request.getRequestURI().getScheme();
                    callbackHandler.handle(new Callback[]{new MechanismInformationCallback(new MechanismInformation(){

                        @Override
                        public String getProtocol() {
                            return protocol;
                        }

                        @Override
                        public String getMechanismType() {
                            return "HTTP";
                        }

                        @Override
                        public String getMechanismName() {
                            return mechanismName;
                        }

                        @Override
                        public String getHostName() {
                            return hostName;
                        }
                    })});
                }
                catch (Throwable e) {
                    throw ElytronMessages.log.unableToLocateMechanismConfiguration(e).toHttpAuthenticationException();
                }
                mechanism.evaluateRequest(request);
            }
        } : null;
    }
}

