/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.lockstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore;
import com.arjuna.ats.txoj.exceptions.LockStoreException;
import com.arjuna.ats.txoj.lockstore.LockStore;
import com.arjuna.ats.txoj.logging.txojLogger;

public class BasicPersistentLockStore
extends LockStore {
    private ParticipantStore _lockStore;
    private static final String LOCK_ROOT = "LockStore";

    public BasicPersistentLockStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"BasicPersistentLockStore.BasicPersistentLockStore()");
        }
        this._lockStore = new ShadowingStore(objectStoreEnvironmentBean);
    }

    @Override
    public InputObjectState read_state(Uid u, String tName) throws LockStoreException {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("BasicPersistentLockStore.read_state(" + u + ", " + tName + ")"));
        }
        try {
            return this._lockStore.read_committed(u, LOCK_ROOT + tName);
        }
        catch (ObjectStoreException e) {
            throw new LockStoreException("Persistent store error.", e);
        }
    }

    @Override
    public boolean remove_state(Uid u, String tName) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("BasicPersistentLockStore.remove_state(" + u + ", " + tName + ")"));
        }
        try {
            return this._lockStore.remove_committed(u, LOCK_ROOT + tName);
        }
        catch (ObjectStoreException e) {
            return false;
        }
    }

    @Override
    public boolean write_committed(Uid u, String tName, OutputObjectState state) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("BasicPersistentLockStore.write_committed(" + u + ", " + tName + ", " + state + ")"));
        }
        try {
            return this._lockStore.write_committed(u, LOCK_ROOT + tName, state);
        }
        catch (ObjectStoreException e) {
            return false;
        }
    }
}

