/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal.deployment;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.security.Principal;
import java.sql.Driver;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.datasources.agroal.AgroalExtension;
import org.wildfly.extension.datasources.agroal.deployment.DataSourceDefinitionService;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;

class DataSourceDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    private static final ServiceName DATASOURCE_DEFINITION_SERVICE_PREFIX = AgroalExtension.BASE_SERVICE_NAME.append(new String[]{"datasource-definition"});
    private static final String DESCRIPTION_PROP = "description";
    private static final String DATABASE_NAME_PROP = "databaseName";
    private static final String PORT_NUMBER_PROP = "portNumber";
    private static final String SERVER_NAME_PROP = "serverName";
    private static final String MAX_STATEMENTS_PROP = "maxStatements";
    private static final String LOGIN_TIMEOUT_PROP = "loginTimeout";
    private String className;
    private String description;
    private String url;
    private String databaseName = "";
    private String serverName = "";
    private int portNumber = -1;
    private int loginTimeout = -1;
    private int isolationLevel = -1;
    private boolean transactional = true;
    private int initialPoolSize = -1;
    private int maxIdleTime = -1;
    private int maxPoolSize = -1;
    private int maxStatements = -1;
    private int minPoolSize = -1;
    private String user;
    private String password;

    public DataSourceDefinitionInjectionSource(String jndiName) {
        super(jndiName);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = new AgroalConnectionFactoryConfigurationSupplier();
        try {
            Class providerClass = ((Module)phaseContext.getDeploymentUnit().getAttachment(Attachments.MODULE)).getClassLoader().loadClass(this.className);
            if (providerClass != null && !DataSource.class.isAssignableFrom(providerClass) && !Driver.class.isAssignableFrom(providerClass)) {
                throw AgroalLogger.SERVICE_LOGGER.invalidDeploymentConnectionProvider();
            }
            connectionFactoryConfiguration.connectionProviderClass(providerClass);
        }
        catch (ClassNotFoundException e) {
            throw AgroalLogger.SERVICE_LOGGER.loadClassDeploymentException(e, this.className);
        }
        for (Map.Entry property : this.properties.entrySet()) {
            connectionFactoryConfiguration.jdbcProperty((String)property.getKey(), (String)property.getValue());
        }
        if (this.databaseName != null && !this.databaseName.isEmpty()) {
            connectionFactoryConfiguration.jdbcProperty(DATABASE_NAME_PROP, this.databaseName);
        }
        if (this.description != null && !this.description.isEmpty()) {
            connectionFactoryConfiguration.jdbcProperty(DESCRIPTION_PROP, this.description);
        }
        if (this.serverName != null && !this.serverName.isEmpty()) {
            connectionFactoryConfiguration.jdbcProperty(SERVER_NAME_PROP, this.serverName);
        }
        if (this.portNumber >= 0) {
            connectionFactoryConfiguration.jdbcProperty(PORT_NUMBER_PROP, Integer.toString(this.portNumber));
        }
        if (this.loginTimeout >= 0) {
            connectionFactoryConfiguration.jdbcProperty(LOGIN_TIMEOUT_PROP, Integer.toString(this.loginTimeout));
        }
        if (this.maxStatements >= 0) {
            connectionFactoryConfiguration.jdbcProperty(MAX_STATEMENTS_PROP, Integer.toString(this.maxStatements));
        }
        if (this.url != null && !this.url.isEmpty()) {
            connectionFactoryConfiguration.jdbcUrl(this.url);
        }
        if (this.user != null && !this.user.isEmpty()) {
            connectionFactoryConfiguration.principal((Principal)new NamePrincipal(this.user));
        }
        if (this.password != null && !this.password.isEmpty()) {
            connectionFactoryConfiguration.credential((Object)new SimplePassword(this.password));
        }
        connectionFactoryConfiguration.jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.fromLevel((int)this.isolationLevel));
        AgroalConnectionPoolConfigurationSupplier connectionPoolConfiguration = new AgroalConnectionPoolConfigurationSupplier();
        connectionPoolConfiguration.connectionFactoryConfiguration((Supplier)connectionFactoryConfiguration);
        if (this.initialPoolSize >= 0) {
            connectionPoolConfiguration.initialSize(this.initialPoolSize);
        }
        if (this.minPoolSize >= 0) {
            connectionPoolConfiguration.minSize(this.minPoolSize);
        }
        if (this.maxPoolSize >= 0) {
            connectionPoolConfiguration.maxSize(this.maxPoolSize);
        }
        if (this.maxIdleTime >= 0) {
            connectionPoolConfiguration.reapTimeout(Duration.ofSeconds(this.maxIdleTime));
        }
        AgroalDataSourceConfigurationSupplier dataSourceConfiguration = new AgroalDataSourceConfigurationSupplier();
        dataSourceConfiguration.connectionPoolConfiguration((Supplier)connectionPoolConfiguration);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)this.jndiName);
        ServiceName dataSourceServiceName = DATASOURCE_DEFINITION_SERVICE_PREFIX.append(new String[]{bindInfo.getBinderServiceName().getCanonicalName()});
        BinderService binderService = new BinderService(bindInfo.getBindName(), (Object)this);
        phaseContext.getServiceTarget().addService(bindInfo.getBinderServiceName(), (org.jboss.msc.service.Service)binderService).addDependency(dataSourceServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).install();
        ServiceBuilder svcBuilder = phaseContext.getServiceTarget().addService(dataSourceServiceName);
        Supplier tsrSupplier = null;
        if (this.transactional) {
            tsrSupplier = svcBuilder.requires(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY);
        }
        DataSourceDefinitionService dataSourceService = new DataSourceDefinitionService(bindInfo, this.transactional, dataSourceConfiguration, tsrSupplier);
        svcBuilder.setInstance((Service)dataSourceService).install();
        serviceBuilder.addDependency(bindInfo.getBinderServiceName()).addDependency(dataSourceServiceName, ManagedReferenceFactory.class, injector);
    }
}

