/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import org.jgroups.util.ThreadFactory;

public class Runner
implements Runnable,
Closeable {
    protected final ThreadFactory factory;
    protected final String thread_name;
    protected final Runnable function;
    protected final Runnable stop_function;
    protected volatile boolean running;
    protected Thread thread;

    public Runner(ThreadFactory factory, String thread_name, Runnable function, Runnable stop_function) {
        this.factory = factory;
        this.thread_name = thread_name;
        this.function = function;
        this.stop_function = stop_function;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        if (this.thread == null || !this.thread.isAlive()) {
            String name = this.thread_name != null ? this.thread_name : "runner";
            this.thread = this.factory != null ? this.factory.newThread(this, name) : new Thread((Runnable)this, name);
            this.running = true;
            this.thread.start();
        }
    }

    public synchronized void stop() {
        this.running = false;
        Thread tmp = this.thread;
        this.thread = null;
        if (tmp != null) {
            tmp.interrupt();
            if (tmp.isAlive()) {
                try {
                    tmp.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.stop_function != null) {
            this.stop_function.run();
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.function.run();
            }
            catch (Throwable throwable) {}
        }
    }
}

