/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ActivationHandler;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class InitialPingHandler
extends ActivationHandler {
    private static final Log log = LogFactory.getLog(InitialPingHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    static final String NAME = "initial-ping-handler";
    private final PingOperation ping;

    public InitialPingHandler(PingOperation ping) {
        this.ping = ping;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (trace) {
            log.tracef("Activating channel %s", channel);
        }
        ChannelRecord channelRecord = ChannelRecord.of(channel);
        this.ping.invoke(channel);
        this.ping.whenComplete((result, throwable) -> {
            if (trace) {
                log.tracef("Initial ping completed with result %s/%s", result, throwable);
            }
            if (throwable != null) {
                channelRecord.completeExceptionally((Throwable)throwable);
            } else {
                channelRecord.complete(channel);
            }
        });
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

