/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;

public final class AggregateSaslClientFactory
implements SaslClientFactory {
    private final SaslClientFactory[] factories;

    public AggregateSaslClientFactory(SaslClientFactory ... factories) {
        Assert.checkNotNullParam("factories", factories);
        this.factories = (SaslClientFactory[])factories.clone();
    }

    public AggregateSaslClientFactory(Collection<SaslClientFactory> factories) {
        Assert.checkNotNullParam("factories", factories);
        this.factories = factories.toArray(new SaslClientFactory[factories.size()]);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (SaslClientFactory factory : this.factories) {
            SaslClient saslClient;
            if (factory == null || (saslClient = factory.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh)) == null) continue;
            return saslClient;
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        LinkedHashSet names = new LinkedHashSet();
        for (SaslClientFactory factory : this.factories) {
            Collections.addAll(names, factory.getMechanismNames(props));
        }
        return names.toArray(new String[names.size()]);
    }
}

