/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.TimerTask;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;

public class CalendarTimerTask
extends TimerTask<CalendarTimer> {
    public CalendarTimerTask(CalendarTimer calendarTimer) {
        super(calendarTimer);
    }

    @Override
    protected void callTimeout(TimerImpl timer) throws Exception {
        CalendarTimer calendarTimer = (CalendarTimer)timer;
        if (calendarTimer.getNextExpiration() != null && !calendarTimer.isInRetry()) {
            calendarTimer.scheduleTimeout(false);
        }
        this.invokeBeanMethod(calendarTimer);
    }

    @Override
    protected void invokeBeanMethod(TimerImpl timer) throws Exception {
        CalendarTimer calendarTimer = (CalendarTimer)timer;
        if (calendarTimer.isAutoTimer()) {
            TimedObjectInvoker invoker = this.timerService.getInvoker();
            invoker.callTimeout(calendarTimer, calendarTimer.getTimeoutMethod());
        } else {
            this.timerService.getInvoker().callTimeout(calendarTimer);
        }
    }

    @Override
    protected Date calculateNextTimeout(TimerImpl timer) {
        Date currentTimeout = timer.getNextExpiration();
        if (currentTimeout == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentTimeout);
        Calendar nextTimeout = ((CalendarTimer)timer).getCalendarTimeout().getNextTimeout(cal);
        if (nextTimeout != null) {
            return nextTimeout.getTime();
        }
        return null;
    }

    @Override
    protected void scheduleTimeoutIfRequired(TimerImpl timer) {
        if (timer.getNextExpiration() != null) {
            timer.scheduleTimeout(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postTimeoutProcessing(TimerImpl timer) throws InterruptedException {
        timer.lock();
        try {
            CalendarTimer calendarTimer = (CalendarTimer)timer;
            TimerState timerState = calendarTimer.getState();
            if (timerState != TimerState.CANCELED && timerState != TimerState.EXPIRED) {
                if (calendarTimer.getNextExpiration() == null) {
                    this.timerService.expireTimer(calendarTimer);
                } else {
                    calendarTimer.setTimerState(TimerState.ACTIVE);
                    this.timerService.persistTimer(calendarTimer, false);
                }
            }
        }
        finally {
            timer.unlock();
        }
    }
}

