/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query;

import org.hibernate.Incubating;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.NotAuditedException;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ArgumentsTools;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.internal.impl.EntitiesAtRevisionQuery;
import org.hibernate.envers.query.internal.impl.EntitiesModifiedAtRevisionQuery;
import org.hibernate.envers.query.internal.impl.RevisionsOfEntityQuery;

public class AuditQueryCreator {
    private final EnversService enversService;
    private final AuditReaderImplementor auditReaderImplementor;

    public AuditQueryCreator(EnversService enversService, AuditReaderImplementor auditReaderImplementor) {
        this.enversService = enversService;
        this.auditReaderImplementor = auditReaderImplementor;
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        this.checkEntityAudited(c.getName());
        return new EntitiesAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, revision, false);
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, String entityName, Number revision) {
        return this.forEntitiesAtRevision(c, entityName, revision, false);
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, String entityName, Number revision, boolean includeDeletions) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        this.checkEntityAudited(entityName);
        return new EntitiesAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, entityName, revision, includeDeletions);
    }

    public AuditQuery forEntitiesModifiedAtRevision(Class<?> c, String entityName, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        this.checkEntityAudited(entityName);
        return new EntitiesModifiedAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, entityName, revision);
    }

    public AuditQuery forEntitiesModifiedAtRevision(Class<?> c, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = EntityTools.getTargetClassIfProxied(c);
        this.checkEntityAudited(c.getName());
        return new EntitiesModifiedAtRevisionQuery(this.enversService, this.auditReaderImplementor, c, revision);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        c = EntityTools.getTargetClassIfProxied(c);
        this.checkEntityAudited(c.getName());
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, c, selectEntitiesOnly, selectDeletedEntities, false, false);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, String entityName, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        c = EntityTools.getTargetClassIfProxied(c);
        this.checkEntityAudited(entityName);
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, c, entityName, selectEntitiesOnly, selectDeletedEntities, false, false);
    }

    @Incubating
    public AuditQuery forRevisionsOfEntity(Class<?> clazz, boolean selectDeletedEntities) {
        clazz = EntityTools.getTargetClassIfProxied(clazz);
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, clazz, false, selectDeletedEntities, true, false);
    }

    @Incubating
    public AuditQuery forRevisionsOfEntity(Class<?> clazz, String entityName, boolean selectDeletedEntities) {
        clazz = EntityTools.getTargetClassIfProxied(clazz);
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, clazz, entityName, false, selectDeletedEntities, true, false);
    }

    @Incubating
    public AuditQuery forRevisionsOfEntityWithChanges(Class<?> clazz, boolean selectDeletedEntities) {
        clazz = EntityTools.getTargetClassIfProxied(clazz);
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, clazz, false, selectDeletedEntities, false, true);
    }

    @Incubating
    public AuditQuery forRevisionsOfEntityWithChanges(Class<?> clazz, String entityName, boolean selectDeletedEntities) {
        clazz = EntityTools.getTargetClassIfProxied(clazz);
        return new RevisionsOfEntityQuery(this.enversService, this.auditReaderImplementor, clazz, entityName, false, selectDeletedEntities, false, true);
    }

    private void checkEntityAudited(String entityName) {
        if (!this.auditReaderImplementor.isEntityNameAudited(entityName)) {
            throw new NotAuditedException(entityName, "Cannot query audit history on a non-audited entity [" + entityName + "].");
        }
    }
}

