/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.PartImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;

public class SPFormAuthenticationRequestWrapper
extends HttpServletRequestWrapper {
    private final FormData formData;
    private List<Part> parts = null;
    private ServletInputStream servletInputStream;

    public SPFormAuthenticationRequestWrapper(HttpServletRequest request, FormData formData, byte[] bytes) {
        super(request);
        this.formData = formData;
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        this.servletInputStream = new ServletInputStream(){

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }

            public boolean isFinished() {
                return byteArrayInputStream.available() <= 0;
            }

            public boolean isReady() {
                return !this.isFinished();
            }

            public void setReadListener(ReadListener readListener) {
                throw new IllegalStateException("Cannot set ReadListener: not an async request.");
            }
        };
    }

    public String getParameter(String name) {
        FormData.FormValue formValue;
        String retVal = super.getParameter(name);
        if (retVal == null && this.formData != null && (formValue = this.formData.getFirst(name)) != null) {
            retVal = formValue.getValue();
        }
        return retVal;
    }

    public String[] getParameterValues(String name) {
        List<String> retVal;
        String[] paramsValues = super.getParameterValues(name);
        List<String> list = retVal = paramsValues != null ? Arrays.asList(paramsValues) : null;
        if (retVal == null && this.formData != null) {
            retVal = new ArrayList<String>();
            Deque formValues = this.formData.get(name);
            if (formValues != null) {
                retVal = this.getValuesFromForm(formValues);
            }
        }
        return retVal.isEmpty() ? null : retVal.toArray(new String[retVal.size()]);
    }

    public Map<String, String[]> getParameterMap() {
        Map retVal = super.getParameterMap();
        if (this.formData != null) {
            for (String key : this.formData) {
                ArrayList<String> values;
                Deque formValues;
                if (retVal.containsKey(key) || (formValues = this.formData.get(key)) == null || (values = this.getValuesFromForm(formValues)).isEmpty()) continue;
                retVal.put(key, values.toArray(new String[0]));
            }
        }
        return retVal;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration parameterNames = super.getParameterNames();
        HashSet retVals = new HashSet();
        if (this.formData != null) {
            while (parameterNames.hasMoreElements()) {
                retVals.add(parameterNames.nextElement());
            }
            for (String key : this.formData) {
                if (retVals.contains(key)) continue;
                retVals.add(key);
            }
        }
        final Iterator retValueIterator = retVals.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return retValueIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)retValueIterator.next();
            }
        };
    }

    private ArrayList<String> getValuesFromForm(Deque<FormData.FormValue> formValues) {
        ArrayList<String> values = new ArrayList<String>();
        for (FormData.FormValue value : formValues) {
            if (value.isFile()) continue;
            values.add(value.getValue());
        }
        return values;
    }

    public Part getPart(String name) throws IOException, ServletException {
        Part part = super.getPart(name);
        if (part != null) {
            return part;
        }
        if (this.parts == null) {
            this.loadParts();
        }
        for (Part p : this.parts) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        Collection parts = super.getParts();
        if (parts != null) {
            return parts;
        }
        if (this.parts == null) {
            this.loadParts();
        }
        return this.parts;
    }

    private void loadParts() {
        HttpServletRequestImpl request = (HttpServletRequestImpl)this.getRequest();
        HttpServerExchange exchange = request.getExchange();
        ServletContextImpl servletContext = request.getServletContext();
        ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (this.parts == null) {
            ArrayList<Part> parts = new ArrayList<Part>();
            if (this.formData != null) {
                for (String namedPart : this.formData) {
                    for (FormData.FormValue part : this.formData.get(namedPart)) {
                        parts.add((Part)new PartImpl(namedPart, part, requestContext.getOriginalServletPathMatch().getServletChain().getManagedServlet().getMultipartConfig(), servletContext, request));
                    }
                }
            }
            this.parts = parts;
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.servletInputStream;
    }
}

