/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceContext;
import org.wildfly.clustering.server.singleton.Lifecycle;
import org.wildfly.clustering.server.singleton.StartCommand;
import org.wildfly.clustering.server.singleton.StopCommand;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.service.SingletonService;

public abstract class AbstractDistributedSingletonService<C extends Lifecycle>
implements SingletonService,
Lifecycle,
ServiceProviderRegistration.Listener,
Supplier<C> {
    private final ServiceName name;
    private final Supplier<ServiceProviderRegistry<ServiceName>> registry;
    private final Supplier<CommandDispatcherFactory> dispatcherFactory;
    private final SingletonElectionPolicy electionPolicy;
    private final int quorum;
    private final Function<ServiceTarget, Lifecycle> primaryLifecycleFactory;
    private final AtomicBoolean primary = new AtomicBoolean(false);
    private volatile Lifecycle primaryLifecycle;
    private volatile CommandDispatcher<C> dispatcher;
    private volatile ServiceProviderRegistration<ServiceName> registration;

    public AbstractDistributedSingletonService(DistributedSingletonServiceContext context, Function<ServiceTarget, Lifecycle> primaryLifecycleFactory) {
        this.name = context.getServiceName();
        this.registry = context.getServiceProviderRegistry();
        this.dispatcherFactory = context.getCommandDispatcherFactory();
        this.electionPolicy = context.getElectionPolicy();
        this.quorum = context.getQuorum();
        this.primaryLifecycleFactory = primaryLifecycleFactory;
    }

    public void start(StartContext context) throws StartException {
        ServiceTarget target = context.getChildTarget();
        this.primaryLifecycle = this.primaryLifecycleFactory.apply(target);
        this.dispatcher = this.dispatcherFactory.get().createCommandDispatcher((Object)this.name, this.get());
        this.registration = this.registry.get().register((Object)this.name, (ServiceProviderRegistration.Listener)this);
    }

    public void stop(StopContext context) {
        this.registration.close();
        this.dispatcher.close();
    }

    public synchronized void providersChanged(Set<Node> nodes) {
        Group group = this.registry.get().getGroup();
        ArrayList candidates = new ArrayList(group.getMembership().getMembers());
        candidates.retainAll(nodes);
        if (candidates.isEmpty() || ((Node)candidates.get(0)).equals(group.getLocalMember())) {
            boolean quorumMet;
            int size = candidates.size();
            boolean bl = quorumMet = size >= this.quorum;
            if (this.quorum > 1 && size == this.quorum) {
                ClusteringServerLogger.ROOT_LOGGER.quorumJustReached(this.name.getCanonicalName(), this.quorum);
            }
            Node elected = quorumMet ? this.electionPolicy.elect(candidates) : null;
            try {
                if (elected != null) {
                    ClusteringServerLogger.ROOT_LOGGER.elected(elected.getName(), this.name.getCanonicalName());
                    for (CompletionStage stage : this.dispatcher.executeOnGroup((Command)new StopCommand(), new Node[]{elected}).values()) {
                        try {
                            stage.toCompletableFuture().join();
                        }
                        catch (CancellationException cancellationException) {}
                    }
                    this.dispatcher.executeOnMember((Command)new StartCommand(), elected).toCompletableFuture().join();
                } else {
                    if (quorumMet) {
                        ClusteringServerLogger.ROOT_LOGGER.noPrimaryElected(this.name.getCanonicalName());
                    } else {
                        ClusteringServerLogger.ROOT_LOGGER.quorumNotReached(this.name.getCanonicalName(), this.quorum);
                    }
                    for (CompletionStage stage : this.dispatcher.executeOnGroup((Command)new StopCommand(), new Node[0]).values()) {
                        try {
                            stage.toCompletableFuture().join();
                        }
                        catch (CancellationException cancellationException) {}
                    }
                }
            }
            catch (CommandDispatcherException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.primary.compareAndSet(false, true)) {
            ClusteringServerLogger.ROOT_LOGGER.startSingleton(this.name.getCanonicalName());
            this.primaryLifecycle.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.primary.compareAndSet(true, false)) {
            ClusteringServerLogger.ROOT_LOGGER.stopSingleton(this.name.getCanonicalName());
            this.primaryLifecycle.stop();
        }
    }

    public boolean isPrimary() {
        return this.primary.get();
    }

    int getQuorum() {
        return this.quorum;
    }

    CommandDispatcher<C> getCommandDispatcher() {
        return this.dispatcher;
    }

    ServiceProviderRegistration<ServiceName> getServiceProviderRegistration() {
        return this.registration;
    }
}

