/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.auth.server.event.SecurityEvent;

public final class AuditLogger
implements Consumer<SecurityEvent> {
    private final ExceptionBiConsumer<EventPriority, String, IOException> auditEndpoint;
    private final Function<SecurityEvent, EventPriority> priorityMapper;
    private final Function<SecurityEvent, String> messageFormatter;

    AuditLogger(Builder builder) {
        this.auditEndpoint = (ExceptionBiConsumer)Assert.checkNotNullParam((String)"auditEndpoint", (Object)builder.auditEndpoint);
        this.priorityMapper = (Function)Assert.checkNotNullParam((String)"priorityMapper", (Object)builder.priorityMapper);
        this.messageFormatter = (Function)Assert.checkNotNullParam((String)"messageFormatter", (Object)builder.messageFormatter);
    }

    @Override
    public void accept(SecurityEvent event) {
        try {
            EventPriority priority = this.priorityMapper.apply(event);
            if (priority == EventPriority.OFF) {
                return;
            }
            String formatted = this.messageFormatter.apply(event);
            try {
                this.auditEndpoint.accept((Object)priority, (Object)formatted);
            }
            catch (Throwable throwable) {
                ElytronMessages.audit.endpointUnavaiable(priority.toString(), formatted, throwable);
            }
        }
        catch (Throwable throwable) {
            ElytronMessages.audit.unableToAcceptEvent(throwable);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ExceptionBiConsumer<EventPriority, String, IOException> auditEndpoint;
        private Function<SecurityEvent, EventPriority> priorityMapper;
        private Function<SecurityEvent, String> messageFormatter;

        Builder() {
        }

        public Builder setAuditEndpoint(ExceptionBiConsumer<EventPriority, String, IOException> auditEndpoint) {
            this.auditEndpoint = (ExceptionBiConsumer)Assert.checkNotNullParam((String)"auditEndpoint", auditEndpoint);
            return this;
        }

        public Builder setPriorityMapper(Function<SecurityEvent, EventPriority> priorityMapper) {
            this.priorityMapper = (Function)Assert.checkNotNullParam((String)"priorityMapper", priorityMapper);
            return this;
        }

        public Builder setMessageFormatter(Function<SecurityEvent, String> messageFormatter) {
            this.messageFormatter = (Function)Assert.checkNotNullParam((String)"messageFormatter", messageFormatter);
            return this;
        }

        public Consumer<SecurityEvent> build() {
            return new AuditLogger(this);
        }
    }
}

