/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.devices.content.action.SearchBaseMessageDispatcher;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.metadatamanager.model.SeriesInfo;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SeasonSearchMessageDispatcher
extends SearchBaseMessageDispatcher {
    private static String SERIES_IDS = "seriesIds";
    private static String MATCHING_SERIES_IDS = "matchingSeriesIds";
    private static String MATCHING_SEASON_IDS = "matchingSeasonIds";
    private static String MATCHING_SEASON_COUNT = "matchingSeasonCount";

    public SeasonSearchMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage getResponseMessage(ExpNode searchFields, WorkflowMessage message) {
        ArrayList<String> seriesIdsList = new ArrayList<String>();
        StringTokenizer seriesIdsTokenizer = new StringTokenizer(this.getMessageParameter(message, SERIES_IDS), ",");
        while (seriesIdsTokenizer.hasMoreTokens()) {
            seriesIdsList.add(seriesIdsTokenizer.nextToken());
        }
        ExpValue seriesCondition = new ExpValue((Predicate)new PredicateRightValue("/@documentId", "ECMFSpec", FieldType.ASSET, seriesIdsList, LogicalOperator.IN, Boolean.valueOf(false)));
        ITitleSearchService service = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        List seriesInfo = null;
        try {
            seriesInfo = service.getSeriesInfos(searchFields, (ExpNode)seriesCondition);
        }
        catch (Exception e) {
            String msg = "Failed to search for season: " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
        return this.buildResponse(message, seriesInfo);
    }

    private WorkflowMessage buildResponse(WorkflowMessage message, List<SeriesInfo> seriesInfo) {
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        if (seriesInfo == null) {
            return new WorkflowMessage(uid, key, WorkflowMessage.MessageType.nack);
        }
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        StringBuffer seriesIds = new StringBuffer();
        StringBuffer seasonIds = new StringBuffer();
        int matchingSeriesCount = seriesInfo.size();
        for (SeriesInfo ssInfo : seriesInfo) {
            Long seriesId = ssInfo.getSeriesDocumentId();
            if (seriesIds.length() > 0) {
                seriesIds.append(",");
            }
            seriesIds.append(seriesId == null ? " " : seriesId);
            Long seasonId = ssInfo.getSeasonAssetId();
            if (seasonIds.length() > 0) {
                seasonIds.append(",");
            }
            seasonIds.append(seasonId == null ? " " : seasonId);
        }
        response.putValue(MATCHING_SERIES_IDS, seriesIds.toString());
        response.putValue(MATCHING_SEASON_IDS, seasonIds.toString());
        response.putValue(MATCHING_SEASON_COUNT, String.valueOf(matchingSeriesCount));
        return response;
    }

    @Override
    protected void validateRequest(WorkflowMessage message) {
        try {
            Util.validateRequired((WorkflowMessage)message, (String[])new String[]{SERIES_IDS, FIELD_1_XPATH, FIELD_1_ASSET_TYPE, FIELD_1_VALUE});
        }
        catch (Exception e) {
            throw new RuntimeException("SeriesIds and at least 1 search field must be provided.");
        }
        try {
            StringTokenizer seriesIdsTokenizer = new StringTokenizer(this.getMessageParameter(message, SERIES_IDS), ",");
            while (seriesIdsTokenizer.hasMoreTokens()) {
                String seriesId = seriesIdsTokenizer.nextToken();
                Long.parseLong(seriesId);
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Only numeric values are allowed for seriesIds list");
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid value for seriesIds, expected format is a comma separated list of numbers representing series ids.");
        }
    }
}

