/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.communication;

import com.ericsson.cms.devices.content.communication.CMDeprecatedDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class GetOriginalFileInfoMessageHandler
extends CMDeprecatedDispatcher {
    private static final String MATERIAL_ID = "materialId";
    private static final String ENCODE_PROFILE = "encodeProfile";
    private static final String ENCODE_FORMAT = "encodeFormat";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String ASPECTRATIO = "aspectratio";
    private static final String BITRATE = "bitrate";
    private static final String LOOKUP_KEY = "lookupKey";
    private static final String DURATION = "duration";
    private static final String RESOLUTION = "resolution";
    private static final String MIME_TYPE = "mimeType";
    private static final String FILE_SIZE = "fileSize";
    private static final String FILE_NAME = "fileName";
    private static final String FILE_URI = "fileUri";
    private static final String TITLE_ID = "titleId";
    private static final String ASSET_ID = "assetId";
    private static final String CHECKSUM = "checksum";
    private static final String LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final String MATERIAL_ID_XPATH = "/Fields/CustomFields/CustomField[@name=MaterialId]/@value";
    private static final String ENCODE_PROFILE_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeProfile]/@value";
    private static final String ENCODE_FORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value";

    public GetOriginalFileInfoMessageHandler(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination, "01CM78", "Get Original File Properties");
    }

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)GetOriginalFileInfoMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GetOriginalFileInfoMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private Object getFieldValue(File file, String path) {
        Field field = file.getFirstField(path);
        if (field != null) {
            return field.getTypedValue();
        }
        return null;
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(GetOriginalFileInfoMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{TITLE_ID, ASSET_ID});
        Long titleId = Util.getLongValue((WorkflowMessage)message, (String)TITLE_ID);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleManager service = (ITitleManager)registry.lookup(ITitleManager.class);
        Title title = null;
        try {
            title = service.get(titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, (Throwable)e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Long assetId = Util.getLongValue((WorkflowMessage)message, (String)ASSET_ID);
        Asset groupAsset = title.getAsset();
        if (groupAsset == null) {
            String msg = "Did not get a group object for a given title.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset targetAsset = null;
        for (Asset asset : groupAsset.getAllAssets(false)) {
            if (asset.getId() != assetId.longValue()) continue;
            targetAsset = asset;
            break;
        }
        if (targetAsset == null) {
            String msg = "Did not get an item object for a given assetId.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        File originalFile = null;
        List files = targetAsset.getChildrenOfType(File.class);
        if (files != null) {
            for (File file : files) {
                if (!file.isOriginal()) continue;
                originalFile = file;
                break;
            }
        }
        if (originalFile == null) {
            String msg = "Could not find an original file associated with the given assetId.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        String fileUri = originalFile.getURL() != null ? originalFile.getURL() : "";
        String fileName = originalFile.getName() != null ? originalFile.getName() : "";
        String fileSize = originalFile.getSize();
        String mimeType = originalFile.getMIMEType() != null ? originalFile.getMIMEType() : "";
        String resolution = originalFile.getResolution() != null ? originalFile.getResolution() : "";
        String duration = originalFile.getDuration() != null ? originalFile.getDuration() : "";
        String bitrate = originalFile.getBitrate() != null ? originalFile.getBitrate() : "";
        String aspectratio = originalFile.getAspectratio() != null ? originalFile.getAspectratio() : "";
        String checksum = originalFile.getChecksum() != null ? originalFile.getChecksum() : "";
        String width = originalFile.getWidth() + "";
        String height = originalFile.getHeight() + "";
        String encodeFormat = (String)this_.getFieldValue(originalFile, ENCODE_FORMAT_XPATH);
        String encodeProfile = (String)this_.getFieldValue(originalFile, ENCODE_PROFILE_XPATH);
        String materialId = (String)this_.getFieldValue(originalFile, MATERIAL_ID_XPATH);
        String lookupKey = (String)this_.getFieldValue(originalFile, LOOKUP_KEY_XPATH);
        response.putValue(FILE_URI, fileUri);
        response.putValue(FILE_NAME, fileName);
        response.putValue(FILE_SIZE, fileSize);
        response.putValue(MIME_TYPE, mimeType);
        response.putValue(RESOLUTION, resolution);
        response.putValue(DURATION, duration);
        response.putValue(BITRATE, bitrate);
        response.putValue(ASPECTRATIO, aspectratio);
        response.putValue(WIDTH, width);
        response.putValue(HEIGHT, height);
        response.putValue(ENCODE_FORMAT, encodeFormat);
        response.putValue(ENCODE_PROFILE, encodeProfile);
        response.putValue(MATERIAL_ID, materialId);
        response.putValue(LOOKUP_KEY, lookupKey);
        response.putValue(CHECKSUM, checksum);
        return response;
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(GetOriginalFileInfoMessageHandler this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return GetOriginalFileInfoMessageHandler.handleMessage_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = GetOriginalFileInfoMessageHandler.handleMessage_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

