/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.file;

import com.ericsson.cms.devices.content.file.AbstractGetFilePropertiesMessageDispatcher;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class GetOriginalFilePropertiesMessageDispatcher
extends AbstractGetFilePropertiesMessageDispatcher {
    private static final String TITLE_ID = "titleId";
    private static final String ASSET_ID = "assetId";

    public GetOriginalFilePropertiesMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected File getFile(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (File)GetOriginalFilePropertiesMessageDispatcher.getFile_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GetOriginalFilePropertiesMessageDispatcher.class.getDeclaredMethod("getFile", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ File getFile_aroundBody0(GetOriginalFilePropertiesMessageDispatcher this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLE_ID, ASSET_ID});
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)TITLE_ID);
        long assetId = Util.getLongValue((WorkflowMessage)request, (String)ASSET_ID);
        Title title = this_.getTitle(titleId);
        Asset targetAsset = this_.getAsset(title, assetId);
        if (targetAsset instanceof File) {
            throw new RuntimeException("The asset[" + assetId + "] in title[" + titleId + "] is a file, cannot get original file properties.");
        }
        File originalFile = null;
        for (File file : targetAsset.getDirectDescendantFiles()) {
            if (!file.isOriginal()) continue;
            originalFile = file;
            break;
        }
        return originalFile;
    }

    private static final /* synthetic */ Object getFile_aroundBody1$advice(GetOriginalFilePropertiesMessageDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return GetOriginalFilePropertiesMessageDispatcher.getFile_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            File object = GetOriginalFilePropertiesMessageDispatcher.getFile_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

