/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.ingest;

import com.ericsson.cms.devices.content.ingest.AbstractMetadataIngestMessageDispatcher;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class UpdateTitleForMetadataMessageDispatcher
extends AbstractMetadataIngestMessageDispatcher {
    public UpdateTitleForMetadataMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
        this.writeTitleId = false;
        this.writePlannerId = true;
    }

    @Override
    protected void validateRequiredParameters(WorkflowMessage request) {
        super.validateRequiredParameters(request);
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{"titleId"});
    }

    @Override
    protected TitleIngestResult performIngest(WorkflowMessage request) {
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)"titleId");
        String metadataPath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"metadataPath");
        TitleIngestResult result = null;
        try {
            result = this.getIngestService().updateTitleForMetadata(metadataPath, Long.valueOf(titleId), this.getActionSource(request));
        }
        catch (TitleIngestException e) {
            String msg = "Failed to update title[" + titleId + "] for metadata: " + metadataPath + ", error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg, e);
        }
        return result;
    }
}

