/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.ingest;

import com.ericsson.cms.devices.content.ingest.AbstractPackageIngestMessageDispatcher;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class UpdateTitleForPackageMessageDispatcher
extends AbstractPackageIngestMessageDispatcher {
    public UpdateTitleForPackageMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
        this.writeTitleId = false;
        this.writePlannerId = true;
    }

    @Override
    protected void validateRequiredParameters(WorkflowMessage request) {
        super.validateRequiredParameters(request);
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{"titleId"});
    }

    @Override
    protected TitleIngestResult performIngest(WorkflowMessage request) {
        String metadataPath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"metadataPath");
        String assetFolderPath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"assetFolderPath");
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)"titleId");
        TitleIngestResult result = null;
        try {
            result = this.getIngestService().updateTitleForPackage(metadataPath, assetFolderPath, Long.valueOf(titleId), this.getActionSource(request));
        }
        catch (TitleIngestException e) {
            String msg = "Failed to update title[" + titleId + "] for package folder: " + assetFolderPath + " with metadata file: " + metadataPath + ", error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg, e);
        }
        return result;
    }
}

