/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.metadata;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.ericsson.cms.devices.content.metadata.AssetUtils;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.List;

public class GetAssetIdAndFieldValuesByAssetTypeMessageDispatcher
extends ContentMessageDispatcher {
    private static final String TITLE_ID = "titleId";
    private static final String ASSET_ID = "assetId";
    private static final String ASSET_TYPE = "assetType";
    private static final String FIELD_PREFIX = "field";
    private static final String FIELD_VALUE_PREFIX = "value";

    public GetAssetIdAndFieldValuesByAssetTypeMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLE_ID, ASSET_TYPE});
        long titleId = Util.getLongValue((WorkflowMessage)request, (String)TITLE_ID);
        String assetType = Util.getStringValueTrimmed((WorkflowMessage)request, (String)ASSET_TYPE);
        String fileType = Item.ItemType.FILE.name();
        if (fileType.equals(assetType)) {
            throw new RuntimeException(fileType + " asset type is not supported.");
        }
        Title title = this.getTitle(titleId);
        List assetList = title.getAssets(assetType);
        String assetId = assetList.isEmpty() ? "" : Long.toString(((Asset)assetList.get(0)).getId());
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(ASSET_ID, assetId);
        if (assetId != "") {
            Asset asset = (Asset)assetList.get(0);
            for (int index = 1; index <= 10; ++index) {
                String fieldParameter = this.getIndexedParameterName(FIELD_PREFIX, index);
                String fieldValueParameter = this.getIndexedParameterName(FIELD_VALUE_PREFIX, index);
                String name = Util.getStringValueTrimmed((WorkflowMessage)request, (String)fieldParameter);
                String value = "";
                if (name != null) {
                    String xpath = this.getMetadataService().translateXPath(name);
                    value = xpath != null ? AssetUtils.getFieldValue(asset, xpath) : "";
                }
                response.putValue(fieldValueParameter, value);
            }
        }
        return response;
    }
}

