/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.frame;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public class LineBasedFrameDecoder
extends FrameDecoder {
    private final int maxLength;
    private final boolean failFast;
    private final boolean stripDelimiter;
    private boolean discarding;

    public LineBasedFrameDecoder(int maxLength) {
        this(maxLength, true, false);
    }

    public LineBasedFrameDecoder(int maxLength, boolean stripDelimiter, boolean failFast) {
        this.maxLength = maxLength;
        this.failFast = failFast;
        this.stripDelimiter = stripDelimiter;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int eol = LineBasedFrameDecoder.findEndOfLine(buffer);
        if (eol != -1) {
            ChannelBuffer frame;
            int length = eol - buffer.readerIndex();
            assert (length >= 0) : "Invalid length=" + length;
            if (this.discarding) {
                frame = null;
                buffer.skipBytes(length);
                if (!this.failFast) {
                    this.fail(ctx, "over " + (this.maxLength + length) + " bytes");
                }
            } else {
                byte delim = buffer.getByte(buffer.readerIndex() + length);
                int delimLength = delim == 13 ? 2 : 1;
                frame = this.stripDelimiter ? this.extractFrame(buffer, buffer.readerIndex(), length) : this.extractFrame(buffer, buffer.readerIndex(), length + delimLength);
                buffer.skipBytes(length + delimLength);
            }
            return frame;
        }
        int buffered = buffer.readableBytes();
        if (!this.discarding && buffered > this.maxLength) {
            this.discarding = true;
            if (this.failFast) {
                this.fail(ctx, buffered + " bytes buffered already");
            }
        }
        if (this.discarding) {
            buffer.skipBytes(buffer.readableBytes());
        }
        return null;
    }

    private void fail(ChannelHandlerContext ctx, String msg) {
        Channels.fireExceptionCaught(ctx.getChannel(), (Throwable)new TooLongFrameException("Frame length exceeds " + this.maxLength + " (" + msg + ')'));
    }

    private static int findEndOfLine(ChannelBuffer buffer) {
        int n = buffer.writerIndex();
        for (int i = buffer.readerIndex(); i < n; ++i) {
            byte b = buffer.getByte(i);
            if (b == 10) {
                return i;
            }
            if (b != 13 || i >= n - 1 || buffer.getByte(i + 1) != 10) continue;
            return i;
        }
        return -1;
    }
}

