/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remotingjmx.protocol.v2.VersionedIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

class WelcomeMessageReceiver
implements Channel.Receiver {
    private static final Logger log = Logger.getLogger(WelcomeMessageReceiver.class);
    private final VersionedIoFuture<Void> future;

    private WelcomeMessageReceiver(VersionedIoFuture<Void> future) {
        this.future = future;
    }

    public static IoFuture<Void> awaitWelcomeMessage(Channel channel) {
        VersionedIoFuture<Void> future = new VersionedIoFuture<Void>();
        channel.receiveMessage(new WelcomeMessageReceiver(future));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
        DataInputStream dis = new DataInputStream(messageInputStream);
        try {
            log.tracef("Bytes Available %d", (Object)dis.available());
            byte[] firstThree = new byte[3];
            dis.read(firstThree);
            log.tracef("First Three %s", (Object)new String(firstThree));
            if (!Arrays.equals(firstThree, "JMX".getBytes())) {
                throw new IOException("Invalid leading bytes in header.");
            }
            this.future.setResult(null);
        }
        catch (IOException e) {
            this.future.setException(e);
        }
        finally {
            IoUtils.safeClose(dis);
        }
    }

    @Override
    public void handleError(Channel channel, IOException e) {
        this.future.setException(e);
    }

    @Override
    public void handleEnd(Channel channel) {
        this.future.setException(new IOException("Channel ended"));
    }
}

