/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class LayeredModulePathFactory {
    LayeredModulePathFactory() {
    }

    static File[] resolveLayeredModulePath(File ... modulePath) {
        boolean foundLayers = false;
        ArrayList<File> layeredPath = new ArrayList<File>();
        for (File file : modulePath) {
            layeredPath.add(file);
            LayersConfig layersConfig = LayeredModulePathFactory.getLayersConfig(file);
            File layersDir = new File(file, layersConfig.getLayersPath());
            if (!layersDir.exists()) {
                if (!layersConfig.isConfigured()) continue;
                throw new IllegalStateException("No layers directory found at " + layersDir);
            }
            boolean validLayers = true;
            ArrayList<File> layerFiles = new ArrayList<File>();
            for (String layerName : layersConfig.getLayers()) {
                File layer = new File(layersDir, layerName);
                if (!layer.exists()) {
                    if (layersConfig.isConfigured()) {
                        throw new IllegalStateException(String.format("Cannot find layer %s under directory %s", layerName, layersDir));
                    }
                    validLayers = false;
                    break;
                }
                layerFiles.add(layer);
            }
            if (!validLayers) continue;
            foundLayers = true;
            layeredPath.addAll(layerFiles);
            File[] addOns = new File(file, layersConfig.getAddOnsPath()).listFiles();
            if (addOns == null) continue;
            for (File addOn : addOns) {
                if (!addOn.isDirectory()) continue;
                layeredPath.add(addOn);
            }
        }
        return foundLayers ? layeredPath.toArray(new File[layeredPath.size()]) : modulePath;
    }

    private static LayersConfig getLayersConfig(File repoRoot) {
        LayersConfig layersConfig;
        File layersList = new File(repoRoot, "layers.conf");
        if (!layersList.exists()) {
            return new LayersConfig();
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(layersList), "UTF-8");
            Properties props = new Properties();
            props.load(reader);
            layersConfig = new LayersConfig(props);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                LayeredModulePathFactory.safeClose(reader);
                throw throwable;
            }
        }
        LayeredModulePathFactory.safeClose(reader);
        return layersConfig;
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class LayersConfig {
        private static final String DEFAULT_LAYERS_PATH = "system/layers";
        private static final String DEFAULT_ADD_ONS_PATH = "system/add-ons";
        private final boolean configured;
        private final String layersPath;
        private final String addOnsPath;
        private final List<String> layers;

        private LayersConfig() {
            this.configured = false;
            this.layersPath = DEFAULT_LAYERS_PATH;
            this.addOnsPath = DEFAULT_ADD_ONS_PATH;
            this.layers = Collections.singletonList("base");
        }

        private LayersConfig(Properties properties) {
            this.configured = true;
            this.layersPath = DEFAULT_LAYERS_PATH;
            this.addOnsPath = DEFAULT_ADD_ONS_PATH;
            boolean excludeBase = false;
            String layersProp = (String)properties.get("layers");
            if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) {
                this.layers = excludeBase ? Collections.emptyList() : Collections.singletonList("base");
            } else {
                String[] layerNames = layersProp.split(",");
                this.layers = new ArrayList<String>();
                boolean hasBase = false;
                for (String layerName : layerNames) {
                    if ("base".equals(layerName)) {
                        hasBase = true;
                    }
                    this.layers.add(layerName);
                }
                if (!hasBase && !excludeBase) {
                    this.layers.add("base");
                }
            }
        }

        boolean isConfigured() {
            return this.configured;
        }

        String getLayersPath() {
            return this.layersPath;
        }

        String getAddOnsPath() {
            return this.addOnsPath;
        }

        List<String> getLayers() {
            return this.layers;
        }
    }
}

