/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.LocalMapStatsImpl;
import com.hazelcast.impl.LocalQueueStatsImpl;
import com.hazelcast.impl.LocalTopicStatsImpl;
import com.hazelcast.impl.MemberHealthStatsImpl;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberStateImpl
implements MemberState {
    private static final long serialVersionUID = -1817978625085375340L;
    Address address = new Address();
    MemberHealthStatsImpl memberHealthStats = new MemberHealthStatsImpl();
    Map<String, LocalMapStatsImpl> mapStats = new HashMap<String, LocalMapStatsImpl>();
    Map<String, LocalQueueStatsImpl> queueStats = new HashMap<String, LocalQueueStatsImpl>();
    Map<String, LocalTopicStatsImpl> topicStats = new HashMap<String, LocalTopicStatsImpl>();
    List<Integer> lsPartitions = new ArrayList<Integer>(271);

    @Override
    public void writeData(DataOutput out) throws IOException {
        this.address.writeData(out);
        this.memberHealthStats.writeData(out);
        int mapCount = this.mapStats.size();
        int queueCount = this.queueStats.size();
        int topicCount = this.topicStats.size();
        out.writeInt(mapCount);
        Set<Map.Entry<String, LocalMapStatsImpl>> maps = this.mapStats.entrySet();
        for (Map.Entry<String, LocalMapStatsImpl> mapStatsEntry : maps) {
            out.writeUTF(mapStatsEntry.getKey());
            mapStatsEntry.getValue().writeData(out);
        }
        out.writeInt(queueCount);
        Set<Map.Entry<String, LocalQueueStatsImpl>> queueStatEntries = this.queueStats.entrySet();
        for (Map.Entry<String, LocalQueueStatsImpl> queueStatEntry : queueStatEntries) {
            out.writeUTF(queueStatEntry.getKey());
            queueStatEntry.getValue().writeData(out);
        }
        out.writeInt(topicCount);
        Set<Map.Entry<String, LocalTopicStatsImpl>> topicStatEntries = this.topicStats.entrySet();
        for (Map.Entry<String, LocalTopicStatsImpl> topicStatEntry : topicStatEntries) {
            out.writeUTF(topicStatEntry.getKey());
            topicStatEntry.getValue().writeData(out);
        }
        int partitionCount = this.lsPartitions.size();
        out.writeInt(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            out.writeInt(this.lsPartitions.get(i));
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.address.readData(in);
        this.memberHealthStats.readData(in);
        int mapCount = in.readInt();
        for (int i = 0; i < mapCount; ++i) {
            String mapName = in.readUTF();
            LocalMapStatsImpl localMapStatsImpl = new LocalMapStatsImpl();
            localMapStatsImpl.readData(in);
            this.mapStats.put(mapName, localMapStatsImpl);
        }
        int queueCount = in.readInt();
        for (int i = 0; i < queueCount; ++i) {
            String queueName = in.readUTF();
            LocalQueueStatsImpl localQueueStats = new LocalQueueStatsImpl();
            localQueueStats.readData(in);
            this.queueStats.put(queueName, localQueueStats);
        }
        int topicCount = in.readInt();
        for (int i = 0; i < topicCount; ++i) {
            String topicName = in.readUTF();
            LocalTopicStatsImpl localTopicStats = new LocalTopicStatsImpl();
            localTopicStats.readData(in);
            this.topicStats.put(topicName, localTopicStats);
        }
        int partitionCount = in.readInt();
        for (int i = 0; i < partitionCount; ++i) {
            this.lsPartitions.add(in.readInt());
        }
    }

    public void clearPartitions() {
        this.lsPartitions.clear();
    }

    public void addPartition(int partitionId) {
        this.lsPartitions.add(partitionId);
    }

    @Override
    public List<Integer> getPartitions() {
        return this.lsPartitions;
    }

    @Override
    public MemberHealthStatsImpl getMemberHealthStats() {
        return this.memberHealthStats;
    }

    @Override
    public LocalMapStats getLocalMapStats(String mapName) {
        return this.mapStats.get(mapName);
    }

    @Override
    public LocalQueueStats getLocalQueueStats(String queueName) {
        return this.queueStats.get(queueName);
    }

    @Override
    public LocalTopicStats getLocalTopicStats(String topicName) {
        return this.topicStats.get(topicName);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void putLocalMapStats(String mapName, LocalMapStatsImpl localMapStats) {
        this.mapStats.put(mapName, localMapStats);
    }

    public void putLocalQueueStats(String queueName, LocalQueueStatsImpl localQueueStats) {
        this.queueStats.put(queueName, localQueueStats);
    }

    public void putLocalTopicStats(String name, LocalTopicStatsImpl localTopicStats) {
        this.topicStats.put(name, localTopicStats);
    }

    public String toString() {
        return "MemberStateImpl [" + this.address + "] " + "\n{ " + "\n\t" + this.memberHealthStats + "\n\tmapStats=" + this.mapStats + "\n\tqueueStats=" + this.queueStats + "\n\tpartitions=" + this.lsPartitions + "\n}";
    }
}

