/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.impl.MemberStateImpl;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedClusterState
implements DataSerializable {
    long time;
    List<MemberState> lsMemberStates = new LinkedList<MemberState>();
    Set<String> instanceNames = null;

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeInt(this.lsMemberStates.size());
        for (MemberState memberState : this.lsMemberStates) {
            memberState.writeData(out);
        }
        int nameCount = this.instanceNames == null ? 0 : this.instanceNames.size();
        out.writeInt(nameCount);
        if (this.instanceNames != null) {
            for (String name : this.instanceNames) {
                out.writeUTF(name);
            }
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.time = in.readLong();
        int memberStatsCount = in.readInt();
        for (int i = 0; i < memberStatsCount; ++i) {
            MemberStateImpl memberState = new MemberStateImpl();
            memberState.readData(in);
            this.lsMemberStates.add(memberState);
        }
        int nameCount = in.readInt();
        this.instanceNames = new HashSet<String>(nameCount);
        for (int i = 0; i < nameCount; ++i) {
            this.instanceNames.add(in.readUTF());
        }
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public Set<String> getInstanceNames() {
        return this.instanceNames;
    }

    public List<MemberState> getMemberStates() {
        return this.lsMemberStates;
    }

    public void addMemberState(MemberState memberState) {
        this.lsMemberStates.add(memberState);
    }

    public void setInstanceNames(Set<String> longInstanceNames) {
        this.instanceNames = longInstanceNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimedClusterState{\n");
        for (MemberState memberState : this.lsMemberStates) {
            sb.append("\t");
            sb.append(memberState);
            sb.append("\n");
        }
        sb.append("}\n");
        sb.append("Instances : ");
        sb.append(this.instanceNames);
        return sb.toString();
    }
}

