/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VirtualJarInputStream;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.FilterVirtualFileVisitor;
import org.jboss.vfs.util.MatchAllVirtualFileFilter;
import org.jboss.vfs.util.PathTokenizer;

public final class VirtualFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String lcname;
    private final VirtualFile parent;
    private final int hashCode;

    VirtualFile(String name, VirtualFile parent) {
        this.name = name;
        this.lcname = name.toLowerCase();
        this.parent = parent;
        int result = parent == null ? 1 : parent.hashCode();
        this.hashCode = result = 31 * result + name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getLowerCaseName() {
        return this.lcname;
    }

    public String getPathName() {
        return this.getPathName(false);
    }

    public String getPathNameRelativeTo(VirtualFile parent) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder(160);
        this.getPathNameRelativeTo(parent, builder);
        return builder.toString();
    }

    private void getPathNameRelativeTo(VirtualFile parent, StringBuilder builder) {
        if (this.parent == null) {
            throw new IllegalArgumentException("Given parent is not an ancestor of this virtual file");
        }
        if (this.equals(parent)) {
            return;
        }
        if (!this.parent.equals(parent)) {
            this.parent.getPathNameRelativeTo(parent, builder);
            builder.append('/');
        }
        builder.append(this.name);
    }

    String getPathName(boolean url) {
        StringBuilder builder = new StringBuilder(160);
        VirtualFile parent = this.parent;
        if (parent == null) {
            return this.name;
        }
        builder.append(parent.getPathName());
        if (parent.parent != null) {
            builder.append('/');
        }
        builder.append(this.name);
        if (url && this.isDirectory()) {
            builder.append('/');
        }
        return builder.toString();
    }

    public long getLastModified() {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().getLastModified(mount.getMountPoint(), this);
    }

    public long getSize() {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().getSize(mount.getMountPoint(), this);
    }

    public boolean exists() {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().exists(mount.getMountPoint(), this);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Deprecated
    public boolean isLeaf() {
        return this.isFile();
    }

    public boolean isFile() {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().isFile(mount.getMountPoint(), this);
    }

    public boolean isDirectory() {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().isDirectory(mount.getMountPoint(), this);
    }

    public InputStream openStream() throws IOException {
        if (this.isDirectory()) {
            return new VirtualJarInputStream(this);
        }
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().openInputStream(mount.getMountPoint(), this);
    }

    public boolean delete() {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().delete(mount.getMountPoint(), this);
    }

    public File getPhysicalFile() throws IOException {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().getFile(mount.getMountPoint(), this);
    }

    public VirtualFile getParent() {
        return this.parent;
    }

    public VirtualFile[] getParentFiles() {
        return this.getParentFiles(0);
    }

    public List<VirtualFile> getParentFileList() {
        return Arrays.asList(this.getParentFiles());
    }

    private VirtualFile[] getParentFiles(int idx) {
        VirtualFile[] array = this.parent == null ? new VirtualFile[idx + 1] : this.parent.getParentFiles(idx + 1);
        array[idx] = this;
        return array;
    }

    public List<VirtualFile> getChildren() {
        VirtualFile child;
        if (!this.isDirectory()) {
            return Collections.emptyList();
        }
        VFS.Mount mount = VFS.getMount(this);
        Set<String> submounts = VFS.getSubmounts(this);
        List<String> names = mount.getFileSystem().getDirectoryEntries(mount.getMountPoint(), this);
        ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>(names.size() + submounts.size());
        for (String name : names) {
            child = new VirtualFile(name, this);
            virtualFiles.add(child);
            submounts.remove(name);
        }
        for (String name : submounts) {
            child = new VirtualFile(name, this);
            virtualFiles.add(child);
        }
        return virtualFiles;
    }

    public List<VirtualFile> getChildren(VirtualFileFilter filter) throws IOException {
        if (!this.isDirectory()) {
            return Collections.emptyList();
        }
        if (filter == null) {
            filter = MatchAllVirtualFileFilter.INSTANCE;
        }
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, null);
        this.visit(visitor);
        return visitor.getMatched();
    }

    public List<VirtualFile> getChildrenRecursively() throws IOException {
        return this.getChildrenRecursively(null);
    }

    public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        if (!this.isDirectory()) {
            return Collections.emptyList();
        }
        if (filter == null) {
            filter = MatchAllVirtualFileFilter.INSTANCE;
        }
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, VisitorAttributes.RECURSE);
        this.visit(visitor);
        return visitor.getMatched();
    }

    public void visit(VirtualFileVisitor visitor) throws IOException {
        this.visit(visitor, true);
    }

    private void visit(VirtualFileVisitor visitor, boolean root) throws IOException {
        VisitorAttributes visitorAttributes = visitor.getAttributes();
        if (root && visitorAttributes.isIncludeRoot()) {
            visitor.visit(this);
        }
        if (!this.isDirectory()) {
            return;
        }
        for (VirtualFile child : this.getChildren()) {
            if (!child.isDirectory() || !visitorAttributes.isLeavesOnly()) {
                visitor.visit(child);
            }
            if (!child.isDirectory() || !visitorAttributes.isRecurse(child)) continue;
            child.visit(visitor, false);
        }
    }

    public VirtualFile getChild(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        List<String> pathParts = PathTokenizer.getTokens(path);
        VirtualFile current = this;
        for (String part : pathParts) {
            if (PathTokenizer.isReverseToken(part)) {
                VirtualFile parent = current.parent;
                current = parent == null ? current : parent;
                continue;
            }
            if (PathTokenizer.isCurrentToken(part)) continue;
            current = new VirtualFile(part, current);
        }
        return current;
    }

    public URL toURL() throws MalformedURLException {
        return VFSUtils.getVirtualURL(this);
    }

    public URI toURI() throws URISyntaxException {
        return VFSUtils.getVirtualURI(this);
    }

    public URL asDirectoryURL() throws MalformedURLException {
        String pathName = this.getPathName(false);
        return new URL("vfs", "", -1, this.parent == null ? pathName : pathName + "/");
    }

    public URI asDirectoryURI() throws URISyntaxException {
        String pathName = this.getPathName(false);
        return new URI("vfs", "", this.parent == null ? pathName : pathName + "/", null);
    }

    public URL asFileURL() throws MalformedURLException {
        return new URL("vfs", "", -1, this.getPathName(false));
    }

    public URI asFileURI() throws URISyntaxException {
        return new URI("vfs", "", this.getPathName(false), null);
    }

    public CodeSigner[] getCodeSigners() {
        VFS.Mount mount = VFS.getMount(this);
        return mount.getFileSystem().getCodeSigners(mount.getMountPoint(), this);
    }

    public Certificate[] getCertificates() {
        CodeSigner[] codeSigners = this.getCodeSigners();
        if (codeSigners == null) {
            return null;
        }
        ArrayList<? extends Certificate> certList = new ArrayList<Certificate>(codeSigners.length * 3);
        for (CodeSigner signer : codeSigners) {
            certList.addAll(signer.getSignerCertPath().getCertificates());
        }
        return certList.toArray(new Certificate[certList.size()]);
    }

    public String toString() {
        return '\"' + this.getPathName() + '\"';
    }

    public boolean equals(Object o) {
        return o instanceof VirtualFile && this.equals((VirtualFile)o);
    }

    public boolean equals(VirtualFile o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.hashCode != o.hashCode || !this.name.equals(o.name)) {
            return false;
        }
        VirtualFile parent = this.parent;
        VirtualFile oparent = o.parent;
        return parent != null && parent.equals(oparent) || oparent == null;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

