/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.reader;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.exception.NotAuditedException;
import org.hibernate.envers.exception.RevisionDoesNotExistException;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQueryCreator;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.reader.FirstLevelCache;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.tools.ArgumentsTools;
import org.hibernate.event.EventSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditReaderImpl
implements AuditReaderImplementor {
    private final AuditConfiguration verCfg;
    private final SessionImplementor sessionImplementor;
    private final Session session;
    private final FirstLevelCache firstLevelCache;

    public AuditReaderImpl(AuditConfiguration verCfg, Session session, SessionImplementor sessionImplementor) {
        this.verCfg = verCfg;
        this.sessionImplementor = sessionImplementor;
        this.session = session;
        this.firstLevelCache = new FirstLevelCache();
    }

    private void checkSession() {
        if (!this.session.isOpen()) {
            throw new IllegalStateException("The associated entity manager is closed!");
        }
    }

    @Override
    public SessionImplementor getSessionImplementor() {
        return this.sessionImplementor;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public FirstLevelCache getFirstLevelCache() {
        return this.firstLevelCache;
    }

    @Override
    public <T> T find(Class<T> cls, Object primaryKey, Number revision) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        return this.find(cls, cls.getName(), primaryKey, revision);
    }

    @Override
    public <T> T find(Class<T> cls, String entityName, Object primaryKey, Number revision) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        Object result;
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        if (!this.verCfg.getEntCfg().isVersioned(entityName)) {
            throw new NotAuditedException(entityName, entityName + " is not versioned!");
        }
        if (this.firstLevelCache.contains(entityName, revision, primaryKey)) {
            return (T)this.firstLevelCache.get(entityName, revision, primaryKey);
        }
        try {
            result = this.createQuery().forEntitiesAtRevision(cls, entityName, revision).add(AuditEntity.id().eq(primaryKey)).getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
        return (T)result;
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, Object primaryKey) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        return this.getRevisions(cls, cls.getName(), primaryKey);
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, String entityName, Object primaryKey) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        this.checkSession();
        if (!this.verCfg.getEntCfg().isVersioned(entityName)) {
            throw new NotAuditedException(entityName, entityName + " is not versioned!");
        }
        return this.createQuery().forRevisionsOfEntity(cls, entityName, false, true).addProjection(AuditEntity.revisionNumber()).add(AuditEntity.id().eq(primaryKey)).getResultList();
    }

    @Override
    public Date getRevisionDate(Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        Query query = this.verCfg.getRevisionInfoQueryCreator().getRevisionDateQuery(this.session, revision);
        try {
            Object timestampObject = query.uniqueResult();
            if (timestampObject == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return timestampObject instanceof Date ? (Date)timestampObject : new Date((Long)timestampObject);
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public Number getRevisionNumberForDate(Date date) {
        ArgumentsTools.checkNotNull(date, "Date of revision");
        this.checkSession();
        Query query = this.verCfg.getRevisionInfoQueryCreator().getRevisionNumberForDateQuery(this.session, date);
        try {
            Number res = (Number)query.uniqueResult();
            if (res == null) {
                throw new RevisionDoesNotExistException(date);
            }
            return res;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public <T> T findRevision(Class<T> revisionEntityClass, Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        HashSet<Number> revisions = new HashSet<Number>(1);
        revisions.add(revision);
        Query query = this.verCfg.getRevisionInfoQueryCreator().getRevisionsQuery(this.session, revisions);
        try {
            Object revisionData = query.uniqueResult();
            if (revisionData == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return (T)revisionData;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public <T> Map<Number, T> findRevisions(Class<T> revisionEntityClass, Set<Number> revisions) throws IllegalArgumentException, IllegalStateException {
        HashMap result = new HashMap(revisions.size());
        for (Number revision : revisions) {
            ArgumentsTools.checkNotNull(revision, "Entity revision");
            ArgumentsTools.checkPositive(revision, "Entity revision");
        }
        this.checkSession();
        Query query = this.verCfg.getRevisionInfoQueryCreator().getRevisionsQuery(this.session, revisions);
        try {
            List revisionList = query.list();
            for (Object revision : revisionList) {
                Number revNo = this.verCfg.getRevisionInfoNumberReader().getRevisionNumber(revision);
                result.put(revNo, revision);
            }
            return result;
        }
        catch (HibernateException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public <T> T getCurrentRevision(Class<T> revisionEntityClass, boolean persist) {
        if (!(this.session instanceof EventSource)) {
            throw new IllegalArgumentException("The provided session is not an EventSource!");
        }
        AuditProcess auditProcess = this.verCfg.getSyncManager().get((EventSource)this.session);
        return (T)auditProcess.getCurrentRevisionData(this.session, persist);
    }

    @Override
    public AuditQueryCreator createQuery() {
        return new AuditQueryCreator(this.verCfg, this);
    }

    @Override
    public boolean isEntityClassAudited(Class<?> entityClass) {
        ArgumentsTools.checkNotNull(entityClass, "Entity class");
        this.checkSession();
        String entityName = entityClass.getName();
        return this.verCfg.getEntCfg().isVersioned(entityName);
    }
}

