/*
 * Decompiled with CFR 0.152.
 */
package com.edb.ds.jdbc23;

import com.edb.Driver;
import com.edb.ds.PGPooledConnection;
import com.edb.ds.common.BaseDataSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.PooledConnection;

public class AbstractJdbc23ConnectionPoolDataSource
extends BaseDataSource
implements Serializable {
    private boolean defaultAutoCommit = true;

    @Override
    public String getDescription() {
        return "ConnectionPoolDataSource from " + Driver.getVersion();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new PGPooledConnection(this.getConnection(), this.defaultAutoCommit);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new PGPooledConnection(this.getConnection(user, password), this.defaultAutoCommit);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeBaseObject(out);
        out.writeBoolean(this.defaultAutoCommit);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readBaseObject(in);
        this.defaultAutoCommit = in.readBoolean();
    }
}

