/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.examples;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.examples.TestApp;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class TestClientApp {
    HazelcastClient hz;
    TestApp app;

    public static void main(String[] arguments) {
        new TestClientApp().run();
    }

    public void run() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.message();
        while (true) {
            System.out.print("client > ");
            try {
                String command = in.readLine();
                String[] argsSplit = command.split(" ");
                String[] args = new String[argsSplit.length];
                for (int i = 0; i < argsSplit.length; ++i) {
                    args[i] = argsSplit[i].trim();
                }
                this.handleCommand(args);
                if (this.hz == null) continue;
                this.app = new TestApp((HazelcastInstance)this.hz);
                this.app.start(null);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void handleCommand(String[] args) throws Exception {
        if (args[0].startsWith("connect")) {
            this.connect(args);
        } else {
            if (this.hz == null) {
                this.message();
                return;
            }
            System.out.println("Unknown command. Sample commands:");
            System.out.println("connect 192.168.1.3");
        }
    }

    private void message() {
        System.out.println("Make sure you started Hazelcast server first.");
        System.out.println("You should connect first by typing 'connect <hazelcast-server-ip> <group-name> <group-password>'");
        System.out.println("If group-name is 'dev' and password is 'dev-pass', 'connect <hazelcast-server-ip>' will be enough ");
    }

    private void connect(String[] args) {
        String groupName = "dev";
        String pass = "dev-pass";
        if (args.length > 2) {
            groupName = args[2];
            pass = args[3];
        }
        String ip = args[1];
        System.out.println("Connecting to " + ip);
        String[] ips = null;
        ips = ip.indexOf(58) == -1 ? new String[]{ip + ":5701", ip + ":5702", ip + ":5703"} : new String[]{ip};
        this.hz = HazelcastClient.newHazelcastClient(groupName, pass, ips);
        System.out.println(this.hz.getCluster().getMembers());
    }
}

