/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.clustering.tribes.LoadBalancerMode;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.OperationMode;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.interceptors.DomainFilterInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMode
implements OperationMode {
    private static final Log log = LogFactory.getLog(LoadBalancerMode.class);
    private byte[] loadBalancerDomain;
    private MembershipManager membershipManager;

    public ApplicationMode(byte[] loadBalancerDomain, MembershipManager membershipManager) {
        this.loadBalancerDomain = loadBalancerDomain;
        this.membershipManager = membershipManager;
    }

    @Override
    public void addInterceptors(Channel channel) {
        DomainFilterInterceptor dfi = new DomainFilterInterceptor();
        dfi.setOptionFlag(1024);
        dfi.setDomain(this.loadBalancerDomain);
        channel.addInterceptor((ChannelInterceptor)dfi);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added Domain Filter Interceptor");
        }
    }

    @Override
    public void init(Channel channel) {
    }

    @Override
    public List<MembershipManager> getMembershipManagers() {
        return new ArrayList<MembershipManager>();
    }

    @Override
    public void notifyMemberJoin(final Member member) {
        Thread th = new Thread(){

            public void run() {
                ApplicationMode.this.membershipManager.sendMemberJoinedToAll(member);
            }
        };
        th.start();
    }
}

