/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss;

import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.ots.Verbose;
import org.openorb.pss.connector.ConnectorBase;
import org.openorb.pss.connector.database.DatabaseConnector;
import org.openorb.pss.connector.database.DatabaseSessionManager;
import org.openorb.pss.connector.database.PIDFactory;
import org.openorb.pss.connector.file.FileConnector;
import org.openorb.pss.connector.file.FileSessionManager;
import org.openorb.pss.connector.memory.MemoryConnector;
import org.openorb.pss.registry.ConnectorRegistry;
import org.openorb.pss.util.debug;

public class Initializer
extends LocalObject
implements ORBInitializer {
    public static FileSessionManager _session_manager_file;
    public static DatabaseSessionManager _session_manager_database;
    private ConnectorRegistry registry;

    public void pre_init(ORBInitInfo info) {
        boolean debug2;
        org.openorb.pss.connector.file.PIDFactory.info = info;
        PIDFactory.info = info;
        org.openorb.pss.connector.memory.PIDFactory.info = info;
        this.registry = new ConnectorRegistry();
        try {
            info.register_initial_reference("PSS", (Object)this.registry);
        }
        catch (InvalidName ex) {
            throw new INITIALIZE("Unable to register PersistentStateService");
        }
        this.registry.register_connector(new FileConnector(info));
        this.registry.register_connector(new DatabaseConnector(info));
        this.registry.register_connector(new MemoryConnector(info));
        ORBLoader cfg = ((OpenORBInitInfo)info).orb().getLoader();
        this.register_external_connector(this.registry, cfg);
        boolean boot = cfg.getBooleanProperty("PSS.OTS.Boot", false);
        if (boot) {
            org.openorb.ots.Initializer ots_initializer = new org.openorb.ots.Initializer();
            ots_initializer.pre_init(info);
        }
        if (debug2 = cfg.getBooleanProperty("PSS.Debug", false)) {
            debug.debugMode(true);
        }
        _session_manager_file = new FileSessionManager(info);
        _session_manager_database = new DatabaseSessionManager(info);
        try {
            info.add_server_request_interceptor((ServerRequestInterceptor)_session_manager_file);
            info.add_server_request_interceptor((ServerRequestInterceptor)_session_manager_database);
        }
        catch (DuplicateName dn) {
            Verbose.exception((String)"Initializer", (String)"Duplicate name when adding the intercptor", (Exception)((java.lang.Object)dn));
        }
    }

    public void post_init(ORBInitInfo info) {
    }

    private void register_external_connector(ConnectorRegistry reg, ORBLoader cfg) {
        try {
            String connector_name = cfg.getStringProperty("PSS.connector.name", "");
            if (connector_name.equals("")) {
                return;
            }
            Class<?> connector_clz = Thread.currentThread().getContextClassLoader().loadClass(connector_name);
            ConnectorBase connector = (ConnectorBase)connector_clz.newInstance();
            reg.register_connector(connector);
        }
        catch (Exception ex) {
            System.out.println("Unable to find an external connector !");
        }
    }
}

