/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.compiler.taskdefs;

import java.io.File;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.openorb.compiler.CompileListEntry;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.taskdefs.GenericTask;
import org.openorb.pss.compiler.PsdlCompiler;
import org.openorb.pss.compiler.PsdlCompilerProperties;
import org.openorb.pss.compiler.parser.PsdlParser;
import org.openorb.pss.compiler.taskdefs.StorageProfile;

public class Psdl2Java
extends GenericTask {
    private boolean m_export = true;
    private PsdlParser m_parser = null;
    protected static Psdl2Java s_singleton = null;
    private Vector m_profile_list = new Vector();
    protected String m_persistence_type;
    private String m_postfix;

    public Psdl2Java() {
        if (s_singleton == null) {
            s_singleton = this;
        }
        this.m_comp = new PsdlCompiler();
    }

    public void setExport(boolean export) {
        this.m_export = export;
    }

    protected String getDefaultCacheName() {
        return "psdl2java.cache";
    }

    public void setQuiet(boolean silent) {
        this.m_cp.setM_silentMode(silent);
    }

    public void setVerbose(boolean verbose) {
        this.m_cp.setM_verbose(verbose);
    }

    public void setGenerateAll(boolean gen_all) {
        this.m_cp.setM_map_all(gen_all);
    }

    public void setPIDL(boolean pidl) {
        if (pidl) {
            this.m_cp.setM_pidl(true);
            this.m_cp.setM_map_stub(false);
            this.m_cp.setM_map_skeleton(false);
            this.m_cp.setM_map_tie(false);
        }
    }

    public void setJDK14Code(boolean jdk14) {
        this.m_cp.setM_jdk1_4(jdk14);
    }

    public void setUptodateChecks(boolean uptodate) {
        this.m_uptodate_check = uptodate;
    }

    public void setSrcdir(Path srcDir) {
        if (this.m_src_path == null) {
            this.m_src_path = srcDir;
        } else {
            this.m_src_path.append(srcDir);
        }
    }

    public void setImportLink(String import_link_name) {
        this.m_cp.getM_importLink().addElement(import_link_name);
    }

    public void setDestDir(File dest_dir) {
        if (this.m_cp.getM_packageName() == null) {
            this.m_cp.setM_packageName("");
        }
        this.m_cp.setM_destdir(dest_dir);
    }

    public void setPersistenceType(PersistenceType pt) {
        this.m_persistence_type = pt.getValue();
    }

    public void setExternalWrapper(String wrapper_name) {
        ((PsdlCompilerProperties)this.m_cp).setM_external_wrapper(wrapper_name);
    }

    public void setPostfix(String postfix) {
        this.m_postfix = postfix;
    }

    public void addConfiguredStorage(StorageProfile profile) {
        this.m_profile_list.add(profile);
    }

    protected void validateAttributes() throws BuildException {
        if (this.m_persistence_type != null) {
            StorageProfile sp = new StorageProfile(this.m_persistence_type, this.m_postfix);
            this.m_profile_list.add(sp);
        }
    }

    protected void compile_file(CompileListEntry cle) throws CompilationException {
        PsdlCompilerProperties pcp = (PsdlCompilerProperties)this.m_cp;
        Iterator it = ((AbstractList)this.m_profile_list).iterator();
        pcp.setM_file_persistence(false);
        pcp.setM_database_persistence(false);
        pcp.setM_packageName("");
        pcp.setM_generate_api(true);
        pcp.setM_generate_wrapper(false);
        this.log("Compiling API");
        this.m_comp.compile_file(cle, (CompilerProperties)pcp);
        pcp.setM_generate_api(false);
        pcp.setM_generate_wrapper(true);
        while (it.hasNext()) {
            StorageProfile sp = (StorageProfile)((Object)it.next());
            this.log("Compiling with profile '" + sp.getType() + "' persistence '" + sp.getPostFix() + "' postfix");
            pcp.setM_file_persistence(false);
            pcp.setM_database_persistence(false);
            if ("file".equals(sp.getType())) {
                pcp.setM_file_persistence(true);
            } else if ("database".equals(sp.getType())) {
                pcp.setM_database_persistence(true);
            }
            pcp.setM_packageName(sp.getPostFix());
            this.m_comp.compile_file(cle, (CompilerProperties)pcp);
        }
    }

    protected GenericTask getSingleton() {
        return s_singleton;
    }

    public static class PersistenceType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"memory", "file", "database"};
        }
    }
}

