/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import java.sql.Connection;
import java.sql.SQLException;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosPersistentState.EndOfAssociationCallback;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import org.openorb.ots.SessionManager;
import org.openorb.ots.SessionManagerHelper;
import org.openorb.ots.Verbose;
import org.openorb.pss.connector.database.DatabaseConnector;
import org.openorb.pss.connector.database.DatabaseResource;
import org.openorb.pss.connector.database.DatabaseSession;
import org.openorb.pss.connector.database.PIDFactory;
import org.openorb.pss.util.debug;

public class TransactionalDatabaseSession
extends DatabaseSession
implements TransactionalSession {
    private short _isolation_level;
    private short _association_status;
    private EndOfAssociationCallback _callback;
    private Coordinator _coordinator;
    private ORBInitInfo _info;

    public TransactionalDatabaseSession() {
        this._info = PIDFactory.info;
    }

    public TransactionalDatabaseSession(ORBInitInfo info) {
        this._info = info;
        this._association_status = 0;
    }

    public void setBaseInfo(DatabaseConnector connector, short default_isolation_level, EndOfAssociationCallback callback, short access, Parameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].name.equals("HomeExtension")) {
                this._extension = parameters[i].val.extract_string();
            }
            ++i;
        }
        this._isolation_level = default_isolation_level;
        this._callback = callback;
        this.setBaseInfo(connector, access, parameters);
    }

    protected Connection connectToDatabase() {
        Connection connection = null;
        debug.print("Open a connection to the database...");
        try {
            String user = this.getParameter("User");
            String password = this.getParameter("Password");
            String profile = this.getParameter("Profile");
            Verbose.print((String)"TransactionalDatabaseSession", (String)("connectToDatabase: User=" + user + " Password=" + password + " Profile=" + profile));
            Object obj = this._info.resolve_initial_references("TransactionSessionManager");
            SessionManager session = SessionManagerHelper.narrow((Object)obj);
            connection = session.getConnection(user, password, profile);
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
        try {
            int level = 0;
            switch (this._isolation_level) {
                case 0: {
                    level = 1;
                    break;
                }
                case 1: {
                    level = 2;
                    break;
                }
                case 2: {
                    level = 4;
                    break;
                }
                case 3: {
                    level = 8;
                }
            }
            connection.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            throw new PERSIST_STORE(7, CompletionStatus.COMPLETED_NO);
        }
        return connection;
    }

    public short default_isolation_level() {
        return this._isolation_level;
    }

    public void start(Coordinator transaction) {
        this._coordinator = transaction;
        switch (this._association_status) {
            case 0: {
                this.register_database_resource(transaction);
                this._association_status = 1;
                break;
            }
            case 2: {
                this._association_status = 1;
                break;
            }
            case 1: {
                throw new BAD_OPERATION();
            }
            case 3: {
                this._association_status = 1;
            }
        }
    }

    public void suspend(Coordinator transaction) {
        switch (this._association_status) {
            case 0: {
                throw new PERSIST_STORE(5, CompletionStatus.COMPLETED_NO);
            }
            case 2: {
                throw new BAD_OPERATION();
            }
            case 1: {
                if (this._coordinator.hash_transaction() != transaction.hash_transaction()) {
                    throw new INVALID_TRANSACTION();
                }
                this._association_status = (short)2;
                break;
            }
            case 3: {
                throw new BAD_OPERATION();
            }
        }
    }

    public void end(Coordinator transaction, boolean success) {
        switch (this._association_status) {
            case 0: {
                throw new PERSIST_STORE(5, CompletionStatus.COMPLETED_NO);
            }
            case 1: 
            case 2: {
                if (this._coordinator.hash_transaction() != transaction.hash_transaction()) {
                    throw new INVALID_TRANSACTION();
                }
                if (!success) {
                    this._cache.clear();
                    try {
                        this._datastore.rollback();
                    }
                    catch (Exception exception) {}
                    break;
                }
                this.flush();
                break;
            }
            case 3: {
                throw new BAD_OPERATION();
            }
        }
    }

    public short get_association_status() {
        return this._association_status;
    }

    public Coordinator transaction() {
        return this._coordinator;
    }

    private void register_database_resource(Coordinator coordinator) {
        DatabaseResource _resource = new DatabaseResource(this, coordinator);
        try {
            Object obj = this._info.resolve_initial_references("RootPOA");
            POA rootPOA = POAHelper.narrow((Object)obj);
            byte[] id = rootPOA.activate_object((Servant)_resource);
            Resource resource = ResourceHelper.narrow((Object)rootPOA.id_to_reference(id));
            coordinator.register_resource(resource);
            this._coordinator = coordinator;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove_database_resource() {
        debug.print("A transactional session is now free");
        this._coordinator = null;
        this._association_status = 0;
        if (this._callback != null) {
            this._callback.released(this);
        }
    }

    public boolean is_associated_to(Coordinator transaction) {
        if (this._coordinator == null) {
            return false;
        }
        return this._coordinator.hash_transaction() == transaction.hash_transaction();
    }
}

