/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.LongHolder;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.file.DataEntry;
import org.openorb.pss.connector.file.FileConnector;
import org.openorb.pss.connector.file.FileKeyEnumeration;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.TransactionalDataManagerSerializable;
import org.openorb.pss.util.debug;

public class DataManager {
    protected Hashtable _cache;
    protected Hashtable _index_table;
    protected Hashtable _clean_table;
    private String _home_name;
    protected boolean _lock_flush;
    private long _available_id;
    protected RandomAccessFile _access;
    private short _shared_value;
    private String _key;
    private TransactionalDataManagerSerializable _locked;
    private ORBInitInfo _info;

    public DataManager(String home_name, String datastore_name, ORBInitInfo info) {
        this._cache = new Hashtable();
        this._index_table = new Hashtable();
        this._clean_table = null;
        this._available_id = 0L;
        this._home_name = home_name;
        this._lock_flush = false;
        this._shared_value = 1;
        this._key = home_name + datastore_name;
        this._locked = null;
        this._info = info;
        this.openAndClean(home_name, datastore_name);
        FileConnector.manager.addManager(home_name, this);
    }

    public DataManager() {
    }

    public void share() {
        this._shared_value = (short)(this._shared_value + 1);
    }

    public boolean shared() {
        return this._shared_value == 0;
    }

    public boolean transaction_lock() {
        return this._locked != null;
    }

    public void transaction_unlock() {
        this._locked = null;
    }

    public void transaction_lock(TransactionalDataManagerSerializable lock) {
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            this._locked = lock;
        }
    }

    public void addListener(Thread thread, TransactionalDataManagerSerializable tmz) {
        if (this._locked != null) {
            this._locked.addListener(thread, tmz);
        }
    }

    public String key() {
        return this._key;
    }

    public void finalize() {
        FileConnector.manager.removeManager(this._home_name);
        this.flush();
    }

    public DataEntry read_entry(PID pid) throws NotFoundException {
        DataEntry e = (DataEntry)this._cache.get(pid.short_value_str());
        if (e != null) {
            return e;
        }
        return this.read_entry_from_datastore(pid);
    }

    public DataEntry read_entry_from_clean_table(PID pid) throws NotFoundException {
        return this.read_entry_from_datastore_with_clean_table(pid);
    }

    public void invalidate_entry(PID pid) {
        DataEntry e = (DataEntry)this._cache.get(pid.short_value_str());
        if (e != null) {
            this._cache.remove(pid.short_value_str());
        }
        this.invalidate_entry_into_datastore(pid);
    }

    public void write_entry(DataEntry entry) {
        DataEntry e = (DataEntry)this._cache.get(new String(entry.short_pid));
        if (e != null) {
            this._cache.remove(new String(entry.short_pid));
        }
        this._cache.put(new String(entry.short_pid), entry);
        if (this._cache.size() > 10) {
            this.flush();
        }
    }

    public void flush() {
        Enumeration enumeration = null;
        DataEntry entry = null;
        if (this._cache.size() != 0 && !this._lock_flush) {
            debug.print("Flush all information saved into the cache... [ " + this._home_name + " ]");
            enumeration = this._cache.elements();
            while (enumeration.hasMoreElements()) {
                entry = (DataEntry)enumeration.nextElement();
                if (!entry.valid) continue;
                this.write_entry_into_datastore(entry);
            }
            this._cache.clear();
        }
    }

    public void free_all() {
        debug.print("Free all storage types into datastore [ " + this._home_name + " ]");
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            this._lock_flush = true;
            this._cache.clear();
            Enumeration enumeration = this._index_table.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    Long index = (Long)enumeration.nextElement();
                    if (index == null) {
                        return;
                    }
                    this._access.seek(index);
                    this._access.writeBoolean(false);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            this._index_table.clear();
            this._lock_flush = false;
        }
    }

    public void close() {
        this.flush();
        this._shared_value = (short)(this._shared_value - 1);
        if (this._shared_value == 0) {
            try {
                this._access.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public long nextFreeID() {
        ++this._available_id;
        try {
            this._access.seek(0L);
            this._access.writeLong(this._available_id);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this._available_id;
    }

    public void destroy() {
        this.close();
        try {
            String name = this.buildDatastoreName(this._home_name, this._key.substring(this._home_name.length()));
            File file = new File(name);
            file.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void openAndClean(String home_name, String datastore_dir) {
        File dir = new File(datastore_dir);
        dir.mkdir();
        DataEntry entry = null;
        String name = this.buildDatastoreName(home_name, datastore_dir);
        try {
            boolean exist = new File(name + ".pss").exists();
            this._access = new RandomAccessFile(name + ".pss", "rw");
            if (exist) {
                debug.print("Clean datastorage...");
                RandomAccessFile fout = new RandomAccessFile(name + ".$$$", "rw");
                if (!this.eof()) {
                    this._available_id = this._access.readLong();
                    fout.writeLong(this._available_id);
                }
                while (!this.eof()) {
                    entry = this.read_next_entry();
                    if (!entry.valid) continue;
                    long idx = fout.getFilePointer();
                    this.copy(fout, entry);
                    String str = new String(entry.short_pid);
                    this._index_table.put(str, new Long(idx));
                }
                fout.close();
                this._access.close();
                File f = new File(name + ".pss");
                f.delete();
                f = new File(name + ".$$$");
                f.renameTo(new File(name + ".pss"));
                this._access = new RandomAccessFile(name + ".pss", "rw");
            } else {
                debug.print("No existing file...");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DataEntry read_next_entry() {
        DataEntry entry = new DataEntry();
        try {
            entry.valid = this._access.readBoolean();
            entry.short_pid = new byte[this._access.readInt()];
            this._access.read(entry.short_pid, 0, entry.short_pid.length);
            entry.data = new byte[this._access.readInt()];
            this._access.read(entry.data, 0, entry.data.length);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return entry;
    }

    private boolean eof() {
        try {
            if (this._access.getFilePointer() == this._access.length()) {
                return true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private void copy(RandomAccessFile dout, DataEntry entry) {
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            try {
                dout.writeBoolean(entry.valid);
                dout.writeInt(entry.short_pid.length);
                dout.write(entry.short_pid, 0, entry.short_pid.length);
                dout.writeInt(entry.data.length);
                dout.write(entry.data, 0, entry.data.length);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private DataEntry read_entry_from_datastore(PID pid) throws NotFoundException {
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            Long index = (Long)this._index_table.get(pid.short_value_str());
            if (index == null) {
                String error = "Could not find an index for supplied object identifier.";
                throw new NotFoundException("Could not find an index for supplied object identifier.");
            }
            try {
                this._access.seek(index);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            DataEntry dataEntry = this.read_next_entry();
            return dataEntry;
        }
    }

    private DataEntry read_entry_from_datastore_with_clean_table(PID pid) throws NotFoundException {
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            Long index = (Long)this._clean_table.get(pid.short_value_str());
            if (index == null) {
                String error = "Could not locate an index in the clean table for the supplied identifier";
                throw new NotFoundException("Could not locate an index in the clean table for the supplied identifier");
            }
            try {
                this._access.seek(index);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            DataEntry dataEntry = this.read_next_entry();
            return dataEntry;
        }
    }

    public DataEntry read_entry_from_index(LongHolder index) {
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            try {
                this._access.seek(index.value);
                DataEntry entry = this.read_next_entry();
                index.value = this._access.getFilePointer();
                DataEntry dataEntry = entry;
                return dataEntry;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                DataEntry dataEntry = null;
                return dataEntry;
            }
        }
    }

    private String buildDatastoreName(String home, String dir) {
        String footer = home.substring(home.indexOf(":") + 1);
        footer = footer.substring(0, footer.lastIndexOf(":"));
        return dir + File.separator + this.transform_name(footer);
    }

    private void write_entry_into_datastore(DataEntry entry) {
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            try {
                long idx = this._access.length();
                if (idx == 0L) {
                    idx += 8L;
                }
                this._access.seek(this._access.length());
                this._index_table.put(new String(entry.short_pid), new Long(this._access.getFilePointer()));
                this.copy(this._access, entry);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void invalidate_entry_into_datastore(PID pid) {
        RandomAccessFile randomAccessFile = this._access;
        synchronized (randomAccessFile) {
            debug.print("Invalidate an entry into datastore [ " + this._home_name + " ]");
            try {
                Long index = (Long)this._index_table.get(pid.short_value_str());
                if (index == null) {
                    return;
                }
                this._access.seek(index);
                this._access.writeBoolean(false);
                this._index_table.remove(pid.short_value_str());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void lock_flush(boolean lock) {
        this._lock_flush = lock;
    }

    public String home() {
        return this._home_name;
    }

    public Enumeration content() {
        this.flush();
        return new FileKeyEnumeration(this, this._info);
    }

    public long datastoreSize() {
        try {
            return this._access.length();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public Hashtable get_index_table() {
        return this._index_table;
    }

    public Hashtable get_clean_table() {
        return this._clean_table;
    }

    public Object lock() {
        return this._access;
    }

    private String transform_name(String name) {
        return name.replace('.', '_').replace('/', '_').replace('\\', '_');
    }
}

