/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.Connector;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.pss.connector.ExtendedCatalog;
import org.openorb.pss.connector.Iterator;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileCatalogBase;
import org.openorb.pss.connector.file.FileConnector;
import org.openorb.pss.connector.file.FileIterator;
import org.openorb.pss.connector.file.FileKeyBag;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PIDFactory;
import org.openorb.pss.connector.file.PersistentObjectHome;

public abstract class FileCatalog
extends LocalObject
implements CatalogBase,
FileCatalogBase,
ExtendedCatalog {
    protected FileConnector _connector;
    protected Hashtable _home_incarnations = new Hashtable();
    private short _access;
    private Parameter[] _parameters;
    private ORBInitInfo _info;

    public FileCatalog() {
        this._info = PIDFactory.info;
    }

    public FileCatalog(ORBInitInfo info) {
        this._info = info;
    }

    public Connector connector() {
        return this._connector;
    }

    public void setCatalogInfo(FileConnector connector, short access, Parameter[] parameters) {
        this._connector = connector;
        this._access = access;
        this._parameters = parameters;
    }

    public short access_mode() {
        return this._access;
    }

    public Parameter[] parameters() {
        return this._parameters;
    }

    public StorageHomeBase find_storage_home(String storage_home_id) throws NotFound {
        StorageHomeBase home = (StorageHomeBase)this._home_incarnations.get(storage_home_id);
        if (home == null) {
            Class clz = this._connector.get_storage_home_factory(storage_home_id);
            if (clz == null) {
                throw new NotFound();
            }
            try {
                Object obj = clz.newInstance();
                this.register_home_incarnation(obj, storage_home_id);
                return (StorageHomeBase)obj;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new PersistenceException(11, CompletionStatus.COMPLETED_NO, ex);
            }
        }
        return home;
    }

    public Object find_by_pid(byte[] the_pid) throws NotFound {
        Enumeration enumeration = this._home_incarnations.elements();
        PersistentObjectHome object_home = null;
        StorageHomeBase home = null;
        byte[] catalog_pid = PIDFactory.pid_to_catalog_pid(the_pid, this._info);
        byte[] short_pid = PIDFactory.pid_to_short_pid(the_pid);
        while (enumeration.hasMoreElements()) {
            object_home = (PersistentObjectHome)enumeration.nextElement();
            PID home_pid = object_home.getPID();
            if (!home_pid.is_same_catalog(catalog_pid)) continue;
            home = (StorageHomeBase)((Object)object_home);
            Object object = home.find_by_short_pid(short_pid);
            if (object == null) {
                throw new NotFound();
            }
            return object;
        }
        throw new NotFound();
    }

    public StorageObjectRef find_ref_by_pid(byte[] the_pid) throws NotFound {
        Enumeration enumeration = this._home_incarnations.elements();
        PersistentObjectHome object_home = null;
        byte[] catalog_pid = PIDFactory.pid_to_catalog_pid(the_pid, this._info);
        byte[] short_pid = PIDFactory.pid_to_short_pid(the_pid);
        while (enumeration.hasMoreElements()) {
            object_home = (PersistentObjectHome)enumeration.nextElement();
            PID home_pid = object_home.getPID();
            if (!home_pid.is_same_catalog(catalog_pid)) continue;
            return object_home.create_reference(the_pid);
        }
        throw new NotFound();
    }

    public byte[][] find_all(StorageHomeBase home) {
        PID home_pid = ((PersistentObjectHome)((Object)home)).getPID();
        Enumeration enumeration = this.getSequentialAccess(home_pid);
        Vector<PID> list = new Vector<PID>();
        while (enumeration.hasMoreElements()) {
            list.addElement(PIDFactory.short_pid_to_pid(((FileKeyBag)enumeration.nextElement()).short_pid, home_pid));
        }
        byte[][] all = new byte[list.size()][];
        int i = 0;
        while (i < list.size()) {
            all[i] = ((PID)list.elementAt(i)).value();
            ++i;
        }
        return all;
    }

    public Iterator iterator(StorageHomeBase home) {
        return new FileIterator(home, this);
    }

    public abstract void flush();

    public abstract void refresh();

    public abstract void free_all();

    public abstract void close();

    protected abstract void register_home_incarnation(Object var1, String var2);

    public abstract StorageHomeBase find_home_base(PID var1);

    public abstract Enumeration getSequentialAccess(PID var1);

    public abstract StorageObject create_embedded_object(StorageHomeBase var1, String var2);

    public abstract StorageObject create_empty_object(StorageHomeBase var1, String var2);

    public abstract StorageObject create_object(StorageHomeBase var1, String var2);

    public abstract StorageObject incarnate(StorageHomeBase var1, byte[] var2, String var3) throws NotFoundException;

    public abstract void delete(PID var1, PID var2);

    public abstract void entry(PID var1, PID var2, OutputStream var3);

    public abstract InputStream entry(PID var1, PID var2) throws NotFoundException;

    public abstract OutputStream create_new_entry(PID var1, PID var2);

    public abstract boolean stored(PID var1, PID var2);

    public abstract void setBaseInfo(FileConnector var1, short var2, Parameter[] var3);

    public abstract void destroy(StorageHomeBase var1);

    public abstract void clean(StorageHomeBase var1);
}

