/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosPersistentState.EndOfAssociationCallback;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.SessionPool;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.pss.connector.ConnectorBase;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileCatalogBase;
import org.openorb.pss.connector.file.FileSession;
import org.openorb.pss.connector.file.FileSessionPool;
import org.openorb.pss.connector.file.FlushManager;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.TransactionalFileSession;

public class FileConnector
extends ConnectorBase {
    private Vector _sessions;
    public static FlushManager manager;
    private ORBInitInfo _info;

    public FileConnector(ORBInitInfo info) {
        super("org.openorb.pss.File");
        this._info = info;
        manager = new FlushManager((ORB)((OpenORBInitInfo)info).orb());
        manager.setDaemon(true);
        manager.start();
        this._sessions = new Vector();
    }

    public byte[] get_pid(java.lang.Object obj) {
        try {
            PersistentObject pobj = (PersistentObject)obj;
            return pobj.getPID().value();
        }
        catch (Exception ex) {
            throw new PersistenceException(1, CompletionStatus.COMPLETED_NO, ex);
        }
    }

    public byte[] get_short_pid(java.lang.Object obj) {
        try {
            PersistentObject pobj = (PersistentObject)obj;
            return pobj.getPID().short_value();
        }
        catch (Exception ex) {
            throw new PersistenceException(1, CompletionStatus.COMPLETED_NO, ex);
        }
    }

    public Session create_basic_session(short access_mode, String catalog_type_name, Parameter[] additional_parameters) {
        Session session = null;
        if (catalog_type_name.equals("")) {
            session = new FileSession(this._info);
            ((FileCatalogBase)((java.lang.Object)session)).setBaseInfo(this, access_mode, additional_parameters);
            return session;
        }
        try {
            Class factory = this.get_session_type_factory(catalog_type_name);
            session = (Session)factory.newInstance();
            if (session != null) {
                ((FileCatalogBase)((java.lang.Object)session)).setBaseInfo(this, access_mode, additional_parameters);
                return session;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PersistenceException(6, CompletionStatus.COMPLETED_NO, ex);
        }
        throw new PersistenceException(6, CompletionStatus.COMPLETED_NO);
    }

    public TransactionalSession create_transactional_session(short access_mode, short default_isolation_level, EndOfAssociationCallback callback, String catalog_type_name, Parameter[] additional_parameters) {
        TransactionalSession session = null;
        if (catalog_type_name.equals("")) {
            session = new TransactionalFileSession(this._info);
            ((TransactionalFileSession)session).setBaseInfo(this, default_isolation_level, callback, access_mode, additional_parameters);
            this._sessions.addElement(session);
            return session;
        }
        try {
            Class factory = this.get_session_type_factory(catalog_type_name);
            session = (TransactionalSession)factory.newInstance();
            if (!(session instanceof TransactionalSession)) {
                throw new PERSIST_STORE(12, CompletionStatus.COMPLETED_NO);
            }
            if (session != null) {
                ((TransactionalFileSession)session).setBaseInfo(this, default_isolation_level, callback, access_mode, additional_parameters);
                this._sessions.addElement(session);
                return session;
            }
        }
        catch (Exception ex) {
            throw new PersistenceException(6, CompletionStatus.COMPLETED_NO, ex);
        }
        throw new PersistenceException(6, CompletionStatus.COMPLETED_NO);
    }

    public SessionPool create_session_pool(short access_mode, short tx_policy, String catalog_type_name, Parameter[] additional_parameters) {
        SessionPool session = null;
        if (catalog_type_name.equals("")) {
            session = new FileSessionPool(this._info);
            ((FileSessionPool)session).setBaseInfo(this, catalog_type_name, tx_policy, access_mode, additional_parameters);
            return session;
        }
        try {
            Class factory = this.get_session_pool_type_factory(catalog_type_name);
            session = factory == null ? new FileSessionPool(this._info) : (SessionPool)factory.newInstance();
            if (session != null) {
                ((FileSessionPool)session).setBaseInfo(this, catalog_type_name, tx_policy, access_mode, additional_parameters);
                return session;
            }
        }
        catch (Exception ex) {
            throw new PersistenceException(6, CompletionStatus.COMPLETED_NO, ex);
        }
        throw new PersistenceException(6, CompletionStatus.COMPLETED_NO);
    }

    public TransactionalSession current_session() {
        try {
            Object obj = this._info.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            switch (current.get_status().value()) {
                case 0: {
                    Coordinator coordinator = current.get_control().get_coordinator();
                    TransactionalSession[] sessions = this.sessions(coordinator);
                    if (sessions.length == 0) {
                        return null;
                    }
                    if (sessions.length > 1) {
                        throw new PERSIST_STORE(4, CompletionStatus.COMPLETED_MAYBE);
                    }
                    return sessions[0];
                }
            }
            throw new PersistenceException("Invalid transaction status.");
        }
        catch (Exception ex) {
            throw new PersistenceException("Could not resolve transaction session.", ex);
        }
    }

    public TransactionalSession[] sessions(Coordinator transaction) {
        TransactionalFileSession tf = null;
        Vector<TransactionalFileSession> found = new Vector<TransactionalFileSession>();
        int i = 0;
        while (i < this._sessions.size()) {
            tf = (TransactionalFileSession)this._sessions.elementAt(i);
            if (tf.is_associated_to(transaction)) {
                found.addElement(tf);
            }
            ++i;
        }
        TransactionalSession[] sessions = new TransactionalSession[found.size()];
        int i2 = 0;
        while (i2 < found.size()) {
            sessions[i2] = (TransactionalSession)found.elementAt(i2);
            ++i2;
        }
        return sessions;
    }
}

