/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.ots.Impl.Current;
import org.openorb.ots.Verbose;
import org.openorb.pss.connector.file.FileSessionPool;

public class FileSessionManager
extends LocalObject
implements ServerRequestInterceptor {
    ORBInitInfo m_info;
    private Vector m_registered;

    public FileSessionManager(ORBInitInfo info) {
        this.m_info = info;
        this.m_registered = new Vector();
    }

    public void register(FileSessionPool pool) {
        this.m_registered.addElement(pool);
    }

    private void prepare_session(Coordinator transaction) {
        FileSessionPool pool = null;
        int i = 0;
        while (i < this.m_registered.size()) {
            pool = (FileSessionPool)this.m_registered.elementAt(i);
            TransactionalSession session = pool.connector().current_session();
            if (session == null) {
                session = pool.prepare_free_session();
            }
            session.start(transaction);
            ++i;
        }
    }

    private void suspend_session(Coordinator transaction) {
        FileSessionPool pool = null;
        int i = 0;
        while (i < this.m_registered.size()) {
            pool = (FileSessionPool)this.m_registered.elementAt(i);
            TransactionalSession session = pool.connector().current_session();
            if (session != null) {
                session.suspend(transaction);
            }
            ++i;
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        if (this.m_registered.size() != 0) {
            try {
                org.omg.CosTransactions.Current current = this.getTransactionCurrent(ri);
                switch (current.get_status().value()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        this.prepare_session(current.get_control().get_coordinator());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        if (this.m_registered.size() != 0) {
            try {
                org.omg.CosTransactions.Current current = this.getTransactionCurrent(ri);
                switch (current.get_status().value()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        this.suspend_session(current.get_control().get_coordinator());
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        if (this.m_registered.size() != 0) {
            try {
                org.omg.CosTransactions.Current current = this.getTransactionCurrent(ri);
                switch (current.get_status().value()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        this.suspend_session(current.get_control().get_coordinator());
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String name() {
        return "FileSessionManager";
    }

    public void destroy() {
    }

    private org.omg.CosTransactions.Current getTransactionCurrent(ServerRequestInfo ri) {
        try {
            Object obj = this.m_info.resolve_initial_references("TransactionCurrent");
            org.omg.CosTransactions.Current current = CurrentHelper.narrow((Object)obj);
            PropagationContext pctx = this.getPropagationContext(ri);
            if (null != pctx) {
                ((Current)current).push_txcontext(pctx);
                ((Current)current).pop_txcontext();
            }
            return current;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private PropagationContext getPropagationContext(ServerRequestInfo ri) {
        Verbose.print((String)"DatabaseSessionManager", (String)("getPropagationContext: " + ri.operation()));
        ServiceContext serviceCtx = null;
        try {
            serviceCtx = ri.get_request_service_context(0);
        }
        catch (BAD_PARAM bp) {
            Verbose.print((String)"DatabaseSessionManager", (String)"getPropagationContext: OTS context not found.");
            return null;
        }
        try {
            CodecFactory codecFactory = this.m_info.codec_factory();
            Encoding encoding = new Encoding(0, new Integer(1).byteValue(), new Integer(2).byteValue());
            Codec codec = codecFactory.create_codec(encoding);
            Any any = codec.decode_value(serviceCtx.context_data, PropagationContextHelper.type());
            return PropagationContextHelper.extract((Any)any);
        }
        catch (UnknownEncoding ue) {
            Verbose.fatal((String)"DatabaseSessionManager", (String)"Unknown encoding");
        }
        catch (FormatMismatch fm) {
            Verbose.fatal((String)"DatabaseSessionManager", (String)"Format Mismatch");
        }
        catch (TypeMismatch fm) {
            Verbose.fatal((String)"DatabaseSessionManager", (String)"Type Mismatch");
        }
        return null;
    }
}

