/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.util.Vector;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.SessionPool;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.pss.Initializer;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.file.FileConnector;
import org.openorb.pss.connector.file.FileSession;
import org.openorb.pss.connector.file.PIDFactory;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;

public class FileSessionPool
extends FileSession
implements SessionPool {
    private Vector _pool;
    private short _tx_policy;
    private String _catalog_type_name;
    private short _isolation_level;
    private ORBInitInfo _info;

    public FileSessionPool() {
        this(null);
    }

    public FileSessionPool(ORBInitInfo info) {
        this._info = info == null ? PIDFactory.info : info;
        this._pool = new Vector();
        ORBLoader cfg = ((OpenORBInitInfo)info).orb().getLoader();
        int val = cfg.getIntProperty("PSS.File.Transaction.IsolationLevel", 1);
        switch (val) {
            case 0: {
                this._isolation_level = 0;
                break;
            }
            case 1: {
                this._isolation_level = 1;
                break;
            }
            case 2: {
                this._isolation_level = (short)2;
                break;
            }
            case 3: {
                this._isolation_level = (short)3;
            }
        }
    }

    public void setBaseInfo(FileConnector connector, String catalog_type_name, short tx_policy, short access, Parameter[] parameters) {
        this.setCatalogInfo(connector, access, parameters);
        this._tx_policy = tx_policy;
        this._catalog_type_name = catalog_type_name;
        if (this._tx_policy == 1) {
            Initializer._session_manager_file.register(this);
        }
    }

    public void flush_by_pids(byte[][] pids) {
        PersistentObjectHome home = null;
        Object incarnation = null;
        PID pid = null;
        if (this._tx_policy == 0) {
            int i = 0;
            while (i < pids.length) {
                pid = PIDFactory.pid_byte_to_pid(pids[i]);
                home = (PersistentObjectHome)((Object)this.find_home_base(pid));
                try {
                    incarnation = ((StorageHomeBase)((Object)home)).find_by_short_pid(pid.short_value());
                    home.flush((PersistentObject)incarnation);
                }
                catch (NotFound ex) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            TransactionalSession session = this.connector().current_session();
            if (session.get_association_status() == 0) {
                throw new TRANSACTION_REQUIRED();
            }
            int i = 0;
            while (i < pids.length) {
                pid = PIDFactory.pid_byte_to_pid(pids[i]);
                home = (PersistentObjectHome)((Object)this.find_home_base(pid));
                try {
                    incarnation = ((StorageHomeBase)((Object)home)).find_by_short_pid(pid.short_value());
                    home.flush((PersistentObject)incarnation);
                }
                catch (NotFound ex) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void refresh_by_pids(byte[][] pids) {
        PersistentObjectHome home = null;
        Object incarnation = null;
        PID pid = null;
        if (this._tx_policy == 0) {
            int i = 0;
            while (i < pids.length) {
                pid = PIDFactory.pid_byte_to_pid(pids[i]);
                home = (PersistentObjectHome)((Object)this.find_home_base(pid));
                try {
                    incarnation = ((StorageHomeBase)((Object)home)).find_by_short_pid(pid.short_value());
                    home.refresh((PersistentObject)incarnation);
                }
                catch (NotFound ex) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            TransactionalSession session = this.connector().current_session();
            if (session.get_association_status() == 0) {
                throw new TRANSACTION_REQUIRED();
            }
            int i = 0;
            while (i < pids.length) {
                pid = PIDFactory.pid_byte_to_pid(pids[i]);
                home = (PersistentObjectHome)((Object)this.find_home_base(pid));
                try {
                    incarnation = ((StorageHomeBase)((Object)home)).find_by_short_pid(pid.short_value());
                    home.refresh((PersistentObject)incarnation);
                }
                catch (NotFound ex) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public short transaction_policy() {
        return this._tx_policy;
    }

    public TransactionalSession prepare_free_session() {
        boolean found = false;
        TransactionalSession session = null;
        int i = 0;
        while (i < this._pool.size()) {
            session = (TransactionalSession)this._pool.elementAt(i);
            if (session.get_association_status() == 0) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            return session;
        }
        session = this.connector().create_transactional_session(this.access_mode(), this._isolation_level, null, this._catalog_type_name, this.parameters());
        this._pool.addElement(session);
        return session;
    }
}

