/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObjectRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileCatalog;
import org.openorb.pss.connector.file.PIDFactory;
import org.openorb.pss.connector.file.PersistentObjectHome;
import org.openorb.pss.connector.file.PersistentRef;
import org.openorb.pss.util.debug;

public class FileUtil {
    public static void truncArray(Object[] src, Object[] tgt, int index) {
        if (index == 0) {
            System.arraycopy(src, 1, tgt, 0, tgt.length);
        } else {
            System.arraycopy(src, 0, tgt, 0, index);
            System.arraycopy(src, index + 1, tgt, index, src.length - (index + 1));
        }
    }

    public static void marshalRef(Object ref, OutputStream output) {
        if (ref == null) {
            debug.print("Marshal a NULL reference");
            output.write_long(0);
        } else {
            debug.print("Marshal a reference");
            StorageObjectRef r = (StorageObjectRef)ref;
            byte[] pid = r.get_pid();
            output.write_long(pid.length);
            output.write_octet_array(pid, 0, pid.length);
        }
    }

    public static StorageObjectRef unmarshalRef(Object ref, InputStream input, StorageHomeBase hbase) {
        if (input == null) {
            throw new NullPointerException("Illegal null input stream argument.");
        }
        int size = input.read_long();
        if (size == 0) {
            debug.print("Unmarshal a NULL reference");
            return null;
        }
        byte[] pid = new byte[size];
        input.read_octet_array(pid, 0, size);
        if (ref != null) {
            ((PersistentRef)ref).update(pid);
        } else {
            if (hbase == null) {
                throw new NullPointerException("Illegal null hbase argument supplied in conjunction with null ref agument.");
            }
            StorageHomeBase home = null;
            try {
                debug.print("Unmarshal a reference");
                PID Pid = PIDFactory.pid_byte_to_pid(pid);
                CatalogBase cat = hbase.get_catalog();
                home = ((FileCatalog)cat).find_home_base(Pid);
                if (home == null) {
                    throw new NullPointerException("Null storage home returned from catalog: " + cat);
                }
                ref = ((PersistentObjectHome)((Object)home)).create_reference(pid);
            }
            catch (Exception ex) {
                throw new PersistenceException(1, CompletionStatus.COMPLETED_NO, ex);
            }
        }
        return (StorageObjectRef)ref;
    }
}

