/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.LongHolder;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.file.DataEntry;
import org.openorb.pss.connector.file.DataManager;
import org.openorb.pss.connector.file.NotFoundException;

public class TransactionalDataManager
extends DataManager {
    protected DataManager _delegate;
    private Hashtable _modified;
    private Vector _waited;
    protected boolean _begin;

    public TransactionalDataManager(DataManager delegated) {
        this._delegate = delegated;
        this._begin = false;
        this._modified = new Hashtable();
        this._access = delegated._access;
        this._waited = new Vector();
    }

    public boolean begun() {
        return this._begin;
    }

    public void begin() {
        Object object = this.lock();
        synchronized (object) {
            this.flush();
            this._begin = true;
        }
    }

    public void rollback() {
        Object object = this.lock();
        synchronized (object) {
            this._begin = false;
            this._modified.clear();
            this.resume_waited();
        }
    }

    public void commit() {
        Object object = this.lock();
        synchronized (object) {
            this.apply_modification();
            this._begin = false;
            this.resume_waited();
        }
    }

    public void forget() {
        this._begin = false;
        this._modified.clear();
        this.resume_waited();
    }

    private synchronized void apply_modification() {
        Enumeration enumeration = this._modified.keys();
        String key = null;
        PID pid = null;
        DataEntry entry = null;
        Hashtable table = this.get_index_table();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            if (this._modified.get(key) instanceof PID) {
                pid = (PID)this._modified.get(key);
                this._delegate.invalidate_entry(pid);
                continue;
            }
            if (this._modified.get(key) instanceof DataEntry) {
                entry = (DataEntry)this._modified.get(key);
                this._delegate.write_entry(entry);
                continue;
            }
            this._delegate.free_all();
            break;
        }
        this._modified.clear();
        this._delegate.flush();
    }

    public void resume_waited() {
    }

    public synchronized void share() {
        this._delegate.share();
    }

    public synchronized boolean shared() {
        return this._delegate.shared();
    }

    public synchronized String key() {
        return this._delegate.key();
    }

    public void finalize() {
    }

    public synchronized DataEntry read_entry(PID pid) throws NotFoundException {
        return this._delegate.read_entry(pid);
    }

    public synchronized void invalidate_entry(PID pid) {
        if (this._modified.get(pid.short_value_str()) != null) {
            this._modified.remove(pid.short_value_str());
        }
        this._modified.put(pid.short_value_str(), pid);
    }

    public synchronized void write_entry(DataEntry entry) {
        if (this._modified.get(new String(entry.short_pid)) != null) {
            this._modified.remove(new String(entry.short_pid));
        }
        this._modified.put(new String(entry.short_pid), entry);
    }

    public synchronized void flush() {
        if (!this._begin) {
            this._delegate.flush();
        }
    }

    public synchronized void free_all() {
        if (!this._begin) {
            this._delegate.free_all();
        } else {
            this._modified.put("free all", "free all");
        }
    }

    public synchronized void close() {
        this._delegate.close();
    }

    public synchronized long nextFreeID() {
        return this._delegate.nextFreeID();
    }

    public synchronized DataEntry read_entry_from_index(LongHolder index) {
        return this._delegate.read_entry_from_index(index);
    }

    public synchronized void lock_flush(boolean lock) {
        this._delegate.lock_flush(lock);
    }

    public synchronized String home() {
        return this._delegate.home();
    }

    public synchronized Enumeration content() {
        return this._delegate.content();
    }

    public synchronized long datastoreSize() {
        return this._delegate.datastoreSize();
    }

    public synchronized Hashtable get_index_table() {
        return this._delegate.get_index_table();
    }

    public synchronized Object lock() {
        return this._delegate.lock();
    }
}

