/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import java.util.Enumeration;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CosPersistentState.EndOfAssociationCallback;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.DataManager;
import org.openorb.pss.connector.file.FileConnector;
import org.openorb.pss.connector.file.FileResource;
import org.openorb.pss.connector.file.FileSession;
import org.openorb.pss.connector.file.PIDFactory;
import org.openorb.pss.connector.file.TransactionalDataManager;
import org.openorb.pss.connector.file.TransactionalDataManagerSerializable;

public class TransactionalFileSession
extends FileSession
implements TransactionalSession {
    private short _isolation_level;
    private short _association_status;
    private EndOfAssociationCallback _callback;
    private FileResource _resource;
    private Coordinator _coordinator;
    private ORBInitInfo _info;

    public TransactionalFileSession() {
        this._info = PIDFactory.info;
    }

    public TransactionalFileSession(ORBInitInfo info) {
        this._info = info;
        this._association_status = 0;
    }

    public void setBaseInfo(FileConnector connector, short default_isolation_level, EndOfAssociationCallback callback, short access, Parameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].name.equals("HomeExtension")) {
                this._extension = parameters[i].val.extract_string();
            }
            ++i;
        }
        this.setCatalogInfo(connector, access, parameters);
        this._isolation_level = default_isolation_level;
        this._callback = callback;
    }

    public synchronized DataManager getDataManager(String storage_home_name) {
        TransactionalDataManager t_manager = null;
        DataManager manager = null;
        manager = (DataManager)FileSession._datastores.get(storage_home_name + this.getFileStorageName());
        if (manager == null) {
            manager = new DataManager(storage_home_name, this.getFileStorageName(), this._info);
            FileSession._datastores.put(storage_home_name + this.getFileStorageName(), manager);
        } else {
            manager.share();
        }
        switch (this._isolation_level) {
            case 0: {
                throw new PersistenceException(7, CompletionStatus.COMPLETED_NO);
            }
            case 1: {
                t_manager = new TransactionalDataManager(manager);
                break;
            }
            case 2: {
                throw new PersistenceException(7, CompletionStatus.COMPLETED_NO);
            }
            case 3: {
                t_manager = new TransactionalDataManagerSerializable(manager);
            }
        }
        if (this._coordinator != null) {
            t_manager.begin();
        }
        return t_manager;
    }

    public short default_isolation_level() {
        return this._isolation_level;
    }

    public void start(Coordinator transaction) {
        switch (this._association_status) {
            case 0: {
                this.register_file_resource(transaction);
                this._association_status = 1;
                break;
            }
            case 2: {
                this._association_status = 1;
                break;
            }
            case 1: {
                throw new BAD_OPERATION();
            }
            case 3: {
                this._association_status = 1;
            }
        }
    }

    public void suspend(Coordinator transaction) {
        switch (this._association_status) {
            case 0: {
                throw new PersistenceException(5, CompletionStatus.COMPLETED_NO);
            }
            case 2: {
                throw new BAD_OPERATION();
            }
            case 1: {
                if (this._coordinator.hash_transaction() != transaction.hash_transaction()) {
                    throw new INVALID_TRANSACTION();
                }
                this._association_status = (short)2;
                break;
            }
            case 3: {
                throw new BAD_OPERATION();
            }
        }
    }

    public void end(Coordinator transaction, boolean success) {
        switch (this._association_status) {
            case 0: {
                throw new PersistenceException(5, CompletionStatus.COMPLETED_NO);
            }
            case 1: 
            case 2: {
                if (this._coordinator.hash_transaction() != transaction.hash_transaction()) {
                    throw new INVALID_TRANSACTION();
                }
                if (!success) {
                    try {
                        this._resource.rollback();
                    }
                    catch (Exception exception) {}
                    break;
                }
                this.flush();
                break;
            }
            case 3: {
                throw new BAD_OPERATION();
            }
        }
    }

    public short get_association_status() {
        return this._association_status;
    }

    public Coordinator transaction() {
        if (this._coordinator == null) {
            throw new TRANSACTION_REQUIRED();
        }
        return this._coordinator;
    }

    private void register_file_resource(Coordinator coordinator) {
        this._resource = new FileResource(this, coordinator);
        try {
            Object obj = this._info.resolve_initial_references("RootPOA");
            POA rootPOA = POAHelper.narrow((Object)obj);
            byte[] id = rootPOA.activate_object((Servant)this._resource);
            Resource resource = ResourceHelper.narrow((Object)rootPOA.id_to_reference(id));
            coordinator.register_resource(resource);
            this._coordinator = coordinator;
        }
        catch (Exception ex) {
            // empty catch block
        }
        Enumeration enumeration = this._home_datastores.elements();
        TransactionalDataManager manager = null;
        while (enumeration.hasMoreElements()) {
            manager = (TransactionalDataManager)enumeration.nextElement();
            if (manager.begun()) continue;
            manager.begin();
        }
    }

    public TransactionalDataManager[] get_data_managers() {
        TransactionalDataManager[] managers = new TransactionalDataManager[this._home_datastores.size()];
        Enumeration enumeration = this._home_datastores.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            managers[i++] = (TransactionalDataManager)enumeration.nextElement();
        }
        return managers;
    }

    public void remove_file_resource() {
        this._resource = null;
        this._coordinator = null;
        this._association_status = 0;
        if (this._callback != null) {
            this._callback.released(this);
        }
    }

    public boolean is_associated_to(Coordinator transaction) {
        if (this._coordinator == null) {
            return false;
        }
        return this._coordinator.hash_transaction() == transaction.hash_transaction();
    }
}

