/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullSupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullSupplierHelper;
import org.openorb.notify.benchmark.NotifyBenchmark;

public class StructuredPullConsumer
extends NotifyBenchmark {
    public static final String HDR = "[StructuredPullConsumer] ";
    private static StructuredProxyPullSupplier s_proxy_pull_supplier = null;

    StructuredPullConsumer() {
        super(HDR);
    }

    public static void main(String[] args) {
        System.out.println(HDR);
        try {
            StructuredPullConsumer.setup(args);
            StructuredPullConsumer.pullEvents(s_proxy_pull_supplier);
            StructuredPullConsumer.shutdown();
        }
        catch (SystemException ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    private static void setup(String[] args) {
        NotifyBenchmark.s_orb = ORB.init((String[])args, null);
        EventChannel eventChannel = NotifyBenchmark.getEventChannel(NotifyBenchmark.s_orb, NotifyBenchmark.s_ec_factory = NotifyBenchmark.getEventChannelFactory(NotifyBenchmark.s_orb));
        if (eventChannel == null) {
            System.err.println("[StructuredPullConsumer] No event channel available");
            return;
        }
        ConsumerAdmin consumerAdmin = eventChannel.default_consumer_admin();
        IntHolder proxyId = new IntHolder();
        ProxySupplier proxySupplier = null;
        try {
            proxySupplier = consumerAdmin.obtain_notification_pull_supplier(ClientType.STRUCTURED_EVENT, proxyId);
        }
        catch (AdminLimitExceeded ex) {
            ex.printStackTrace(System.err);
            return;
        }
        s_proxy_pull_supplier = null;
        try {
            s_proxy_pull_supplier = StructuredProxyPullSupplierHelper.narrow((Object)proxySupplier);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return;
        }
        try {
            s_proxy_pull_supplier.connect_structured_pull_consumer(null);
        }
        catch (AlreadyConnected ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    private static void shutdown() {
        System.out.println("[StructuredPullConsumer] Disconnecting (removing) the supplier proxy");
        try {
            s_proxy_pull_supplier.disconnect_structured_pull_supplier();
        }
        catch (TRANSIENT ex) {
            ex.printStackTrace(System.err);
        }
        catch (COMM_FAILURE ex) {
            ex.printStackTrace(System.err);
        }
        NotifyBenchmark.s_orb.shutdown(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void pullEvents(StructuredProxyPullSupplier proxyPullSupplier) {
        System.out.println("[StructuredPullConsumer] Pulling events...");
        try {
            StructuredEvent event;
            while (!NotifyBenchmark.countEvent(event = proxyPullSupplier.pull_structured_event())) {
            }
        }
        catch (Disconnected ex) {
            ex.printStackTrace(System.err);
            return;
        }
        NotifyBenchmark.displayStats();
    }
}

